
// in data 13/07/2022 abbiamo testato spacecraft-mima avendo come spacecraft
// la seriale che parla su STM, mentre mima l'usb del pc

// Librerie
#include "mbed.h"
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h>

// Macros
#define PACKETDIM 15 // temperature
#define word 1 
#define packet 2 // 2 bytes
#define hsk_buf 113 
#define hsk_rx 114 // 114 bytes - 57 telemetry words(housekeeping)
#define hsk_sd_buf 11211
#define hsk_sd 11212 // 11212 bytes - 5606 interferogram data words
#define channel_size 10 // temeprature channel from sen30202

// Serial e periferiche 
Serial spacecraft(USBTX, USBRX); // switchare questo e le print con mima
Serial mima(PC_4, PC_5);
Serial max31865(PA_0, PA_1);
// L16 Actuonix: 
PwmOut actuonix (PB_3);
float offset;
// Relay: configurazione pull-up
DigitalOut Relay5V (PA_7);
DigitalOut Relay12V (PB_4);
DigitalOut Relay24V (PB_5);
DigitalOut Relay15_15_5V (PB_10);

// Buffer: telecommand
volatile int rxTlcPtr; // telecommand receiving buffer
int rxTlcDataCounter = 0; 
char rx_TLC[word+1]; // buffer
char data_TLC[word+1]; // telecommand

// Buffer: standard telemetry
volatile int rxTlmPtr; 
int rxTlmDataCounter = 0;
char rx_TLM[word+1]; // buffer
char data_TLM[word+1]; // standard telemetry

// Buffer: TLMODE telemetry option 1
volatile int rxTlmOpt1Ptr; 
int rxTlmOpt1DataCounter = 0;
char rx_TLMOpt1[hsk_buf+1]; 
char data_TLMOpt1[hsk_buf+1];

// Buffer: TLMODE telemetry option 1
volatile int rxTlmOpt2Ptr; 
int rxTlmOpt2DataCounter = 0;
char rx_TLMOpt2[hsk_sd_buf+1]; 
char data_TLMOpt2[hsk_sd_buf+1];

// Timer
Timer timer; // telecommand
Timer rx; // rx window
float rxWindow = 300 /* seconds */, rxTimeStart, rxTimeStop, rxTimeRead;
float TIMEOUT = 10 /* seconds */, tTimeStart, tTimeStop, tTimeRead;

// TLMODE
volatile int tlmode_option_1, tlmode_option_2, tlmode_tlm;
volatile bool TlcSend;

// SC-MIMA communication: TX/RX
void RxTelecommand();
void TxTelecommand();
void RxTelemetry();
void TxTelemetry();
// System utility
void clearBuffer(char *arr, int arrLen);

// Temperature settings
char tempCH1[channel_size];
char tempCH2[channel_size];
volatile int j; // first channel index
volatile int t; // second channel index
volatile char caRxPacket[PACKETDIM]; // temperature buffer
volatile char nRxCharCount; // temperature char counter

// Routines dedicate alla ricezione di dati della temperatura (Pt100)
void SerialeRxInterrupt(void)
{
    char cReadChar; 
    while((max31865.readable()))
    {
        cReadChar = max31865.getc(); 
        nRxCharCount++; 
        caRxPacket[nRxCharCount] = cReadChar;
    }  
    
    if (nRxCharCount == PACKETDIM) // if it reaches max -> reset
    {
        nRxCharCount = 0;
    }
}

// Main
int main()
{
    // Baudrate
    spacecraft.baud(115200);
    //spacecraft.baud(9600);
    mima.baud(9600);
    //mima.baud(115200);
    max31865.baud(115200);

    // Diagnostica
    spacecraft.printf(" Avvio Spacecraft... \n\r");
    //mima.printf(" Avvio MIMA... \n\r");
    
    // Setup per temperatura
    int nIndex;
    nRxCharCount = 0;
    for(nIndex = 0; nIndex < PACKETDIM; nIndex++)
    {
        caRxPacket[nIndex] = 0;
    }   
    
    // Setup per Actuonix L16      
    actuonix.period_us(1000);
    offset = actuonix.read();
    
    // Setup per Relay: 1 = OFF (1->OFF, 0->ON)
    Relay5V         = 1;
    Relay12V        = 1;
    Relay15_15_5V   = 1;
    Relay24V        = 1;
    
    // Bool flags 
    TlcSend = false;
    
    // Interrupt routine 
    max31865.attach(&SerialeRxInterrupt, Serial::RxIrq);
    spacecraft.attach(&RxTelecommand, Serial::RxIrq);
    mima.attach(&RxTelemetry, Serial::RxIrq);
    
    // Main loop
    while (true)
    {    
        // Telecommand
        timer.start();
        tTimeStart = timer.read();  // in secondi 
        tTimeRead = tTimeStart;
        
        while ((rxTlcPtr < packet) && ((tTimeRead - tTimeStart) < TIMEOUT))
        {
            tTimeRead = timer.read();
        }
        
        timer.stop();
        
        if ((rxTlcPtr == packet) && ((tTimeRead - tTimeStart) < TIMEOUT))
        { 
            __disable_irq(); // disable interrupts so data doesn't arrive while we are doing this
            memcpy(data_TLC, rx_TLC, rxTlcPtr);  
            rxTlcDataCounter = rxTlcPtr;
            rxTlcPtr = 0;                                                 
            //__enable_irq(); // re-enable interrupts
            
            data_TLC[1] = data_TLC[1] >> 1; // read payload data ignoring the LSB
            
            spacecraft.printf("\n\r .... Telecomando ricevuto su DORA! \n\r");
                        
            for (int i = 0; i < sizeof(data_TLC)/sizeof(char); i++)
            {
                spacecraft.printf("> Carattere: %f \n\r", (float)data_TLC[i]);
            }            
            
            data_TLC[rxTlcDataCounter] = 0; // add a null just in case the received data didn't have one at the end
          
            // hw control: set-point init
            offset = 0;
            
            // RX settings
            if (((float)data_TLC[0] != 40) || ((float)data_TLC[0] != 41))
            {
                tlmode_option_1 = 1;
                tlmode_option_2 = 1;
                tlmode_tlm = 0;
            }
            
            // L16 setpoint
            if ((float)data_TLC[0] == 0)
            {
                offset = (float)data_TLC[1];    
                offset = offset/100;    
                actuonix.write(offset);
            }
            // Temperature request
            else if (((float)data_TLC[0] == 16) && ((float)data_TLC[1] == 32))
            {
                // Cleaning buffers
                clearBuffer(tempCH1, sizeof(tempCH1)/sizeof(char));
                clearBuffer(tempCH2, sizeof(tempCH2)/sizeof(char));

                // Index setup
                nRxCharCount = 0;
                int y = 0, u = 0;
                t = 0; j = 0;

                for (int i = 0; i < PACKETDIM; i++)
                {
                    if (caRxPacket[i] == 'S')
                    {
                        j = i + 1;

                        while (j < PACKETDIM)
                        {
                            if (caRxPacket[j] == ';')
                            {
                                break;
                            }
                            else
                            {
                                tempCH1[y++] = caRxPacket[j];
                            }

                            j++;
                        }

                        t = j + 1;

                        while (t < PACKETDIM)
                        {
                            if (caRxPacket[t] == 'P')
                            {
                                break;
                            }
                            else
                            {
                                tempCH2[u++] = caRxPacket[t];
                            }
                            t++;
                        }
                        break;
                    }
                }
                // Send
                spacecraft.puts(tempCH1);
                spacecraft.puts(";");
                spacecraft.puts(tempCH2);
            }
            else if (((float)data_TLC[0] == 121) && ((float)data_TLC[1] == 42))
            {
                Relay5V = 1;
                Relay12V = 1;
                Relay15_15_5V = 1;
                Relay24V = 1;
            }
            else if (((float)data_TLC[0] == 120) && ((float)data_TLC[1] == 85))
            {
                Relay5V = 0;
                Relay12V = 0;
                Relay15_15_5V = 0;
                Relay24V = 0; 
            }
            else if (((float)data_TLC[0] == 120)) // Relay 
            {
                if (((float)data_TLC[1] == 0))
                {
                    Relay12V = 1;
                }
                else if (((float)data_TLC[1] == 1))
                {
                    Relay12V = 0;
                    // since the linear actuator is driven by 12V power
                    offset = actuonix.read();
                    actuonix.write(offset);
                }
                else if (((float)data_TLC[1] == 2))
                {
                    Relay5V = 1; 
                }
                else if (((float)data_TLC[1] == 3))
                {
                    Relay5V = 0; 
                }
                else if (((float)data_TLC[1] == 6))
                {
                    Relay15_15_5V = 1;
                }
                else if (((float)data_TLC[1] == 7))
                {
                    Relay15_15_5V = 0;
                }
                else if (((float)data_TLC[1] == 8))
                {
                    Relay24V = 1;
                }
                else if (((float)data_TLC[1] == 15))
                {
                    Relay24V = 0;
                }
            }
            else if (((float)data_TLC[0] == 40) && ((float)data_TLC[1] == 24))
            {
                tlmode_option_1 = 0;
                tlmode_option_2 = 1;
                tlmode_tlm = 1;
                rxTlmPtr = 0;
                rxTlmOpt1Ptr = 0;
                rxTlmOpt2Ptr = 0;
                spacecraft.printf("> Sono entrato in TLMODE 1 \n\r");
            }
            else if (((float)data_TLC[0] == 41) && ((float)data_TLC[1] == 127))
            {
                tlmode_option_2 = 0;
                tlmode_option_1 = 1;
                tlmode_tlm = 1;
                rxTlmPtr = 0;
                rxTlmOpt1Ptr = 0;
                rxTlmOpt2Ptr = 0;
                spacecraft.printf("> Sono entrato in TLMODE 2 \n\r");
            }
            // Reset global vars 
            else if (((float)data_TLC[0] == 241) && ((float)data_TLC[1] == 127))
            {
                nRxCharCount = 0;
                rxTlcPtr = 0;
                rxTlmOpt1Ptr = 0;
                rxTlmOpt2Ptr = 0;
                rxTlcDataCounter = 0;
                rxTlmOpt1DataCounter = 0;
                rxTlmOpt2DataCounter = 0;
                tlmode_tlm = 1;
                tlmode_option_1 = 1;
                tlmode_option_2 = 1;
                
                for(nIndex = 0; nIndex < PACKETDIM; nIndex++)
                {
                    caRxPacket[nIndex] = 0;
                }   
                
                clearBuffer(data_TLC, sizeof(data_TLC)/sizeof(char));
                clearBuffer(data_TLM, sizeof(data_TLM)/sizeof(char));
                clearBuffer(data_TLMOpt1, sizeof(data_TLMOpt1)/sizeof(char));
                clearBuffer(data_TLMOpt2, sizeof(data_TLMOpt2)/sizeof(char));
                
                spacecraft.printf(".... Reset variabili effettuato! \n\r");
            }
        
            // Send after setting flags and clear
            TxTelecommand();
            spacecraft.printf(".... Telecomando inviato a MIMA ....");
            __enable_irq(); // *********************************************************************
            clearBuffer(rx_TLC, sizeof(rx_TLC)/sizeof(char));
            clearBuffer(data_TLC, sizeof(data_TLC)/sizeof(char));
            
            spacecraft.printf(".... Ho ripulito i buffer di ricezione TLC .... \n\r");
       
            /* *********************************************************** */
            
            //__disable_irq(); // da lavorare su queste chiamate perché se da un lato prevengono 
            // blocco del telecomando durante ricezione, dall'altro impediscono al comando di telemetria di ricevere
            
            if ((TlcSend) && (tlmode_option_1 == 1) && (tlmode_option_2 == 1) && (tlmode_tlm == 0))
            { 
                clearBuffer(data_TLM, sizeof(data_TLM)/sizeof(char));

                // Standard telemetry frame
                rx.start();
                rxTimeStart = rx.read(); 
                rxTimeRead = rxTimeStart;
                
                while ((rxTlmPtr < packet) && ((rxTimeRead - rxTimeStart) < rxWindow))
                {
                    rxTimeRead = rx.read();
                }
                
                rx.stop();
                
                if ((rxTlmPtr == packet) && ((rxTimeRead - rxTimeStart) < rxWindow))
                { 
                    __disable_irq(); 
                    memcpy(data_TLM, rx_TLM, rxTlmPtr);  
                    rxTlmDataCounter = rxTlmPtr;
                    rxTlmPtr = 0;                                                 
                    //__enable_irq();
      
                    data_TLM[rxTlmDataCounter] = 0;
                    
                    TxTelemetry();
                    __enable_irq(); // ***************************************************
                    spacecraft.printf("\n\r Ricevuto Telemetry Standard \n\r");

                }
                else if ((rxTimeRead - rxTimeStart) >= rxWindow)
                {
                    spacecraft.printf("\n\r !!! Scattato il timeout in Telemetry !!! \n\r");
                    rxTlmPtr = 0;
                    for (int i = 0; i < packet; i++)
                    {
                        rx_TLM[i] = '\0';
                        data_TLM[i] = '\0';
                    }
                } // end-else-if:telecommand-send+timeout   
                
                TlcSend = false;
            } // end-if-send-telecommand
            else if ((TlcSend) && (tlmode_option_1 == 0) && (tlmode_option_2 == 1) && (tlmode_tlm == 1))
            {   
                spacecraft.printf("\n\r > Sono entrato in TLMODE 1 - TX Telemetry \n\r");
                clearBuffer(data_TLMOpt1, sizeof(data_TLMOpt1)/sizeof(char));  
                          
                rx.start();
                rxTimeStart = rx.read(); 
                rxTimeRead = rxTimeStart;
                                
                while ((rxTlmOpt1Ptr < hsk_rx) && ((rxTimeRead - rxTimeStart) < rxWindow))
                {
                    rxTimeRead = rx.read();
                }
                
                rx.stop();
                
                if ((rxTlmOpt1Ptr == hsk_rx) && ((rxTimeRead - rxTimeStart) < rxWindow))
                { 
                    __disable_irq(); 
                    memcpy(data_TLMOpt1, rx_TLMOpt1, rxTlmOpt1Ptr);  
                    rxTlmOpt1DataCounter = rxTlmOpt1Ptr;
                    rxTlmOpt1Ptr = 0;                                                 
                    //__enable_irq();
      
                    data_TLMOpt1[rxTlmOpt1DataCounter] = 0;
                    
                    TxTelemetry();
                    __enable_irq(); // ***************************************************
                    spacecraft.printf("\n\r > Ricevuto Telemetry Opt 1 \n\r");

                }
                else if ((rxTimeRead - rxTimeStart) >= rxWindow)
                {
                    mima.printf("\n\r !!! Scattato il timeout in Telemetry Opt 1 !!! \n\r");
                    rxTlmOpt1Ptr = 0;
                    for (int i = 0; i < packet; i++)
                    {
                        rx_TLMOpt1[i] = '\0';
                        data_TLMOpt1[i] = '\0';
                    }
                } 
                TlcSend = false;
            } // end-else-if-send-telecommand
            else if ((TlcSend) && (tlmode_option_1 == 1) && (tlmode_option_2 == 0) && (tlmode_tlm == 1))
            {   
                spacecraft.printf("\n\r > Sono entrato in TLMODE 2 - TX Telemetry \n\r");
                clearBuffer(data_TLMOpt2, sizeof(data_TLMOpt2)/sizeof(char)); 
                           
                rx.start();
                rxTimeStart = rx.read(); 
                rxTimeRead = rxTimeStart;
                                  
                while ((rxTlmOpt2Ptr < hsk_sd) && ((rxTimeRead - rxTimeStart) < rxWindow))
                {
                    rxTimeRead = rx.read();
                }
                
                rx.stop();
                
                if ((rxTlmOpt2Ptr == hsk_sd) && ((rxTimeRead - rxTimeStart) < rxWindow))
                { 
                    __disable_irq(); 
                    memcpy(data_TLMOpt2, rx_TLMOpt2, rxTlmOpt2Ptr);  
                    rxTlmOpt2DataCounter = rxTlmOpt2Ptr;
                    rxTlmOpt2Ptr = 0;                                                 
                    //__enable_irq();
      
                    data_TLMOpt2[rxTlmOpt2DataCounter] = 0;
                    
                    TxTelemetry();
                    __enable_irq(); // ***************************************************
                    spacecraft.printf("\n\r Ricevuto Telemetry Opt 2 \n\r");

                }
                else if ((rxTimeRead - rxTimeStart) >= rxWindow)
                {
                    spacecraft.printf("\n\r !!! Scattato il timeout in Telemetry Opt 2 !!! \n\r");
                    rxTlmOpt2Ptr = 0;
                    for (int i = 0; i < packet; i++)
                    {
                        rx_TLMOpt2[i] = '\0';
                        data_TLMOpt2[i] = '\0';
                    }
                } 
                TlcSend = false;
            } // end-2nd-else-if-send-telecommand
            
            spacecraft.printf("\n\r .... Ho inviato il telecomando entro la finestra di timeout .... \n\r");
            spacecraft.printf(" *************************************** \n\r");
            
            //__enable_irq();
            
        } // end-if:telecommand 
        else if ((tTimeRead - tTimeStart) >= TIMEOUT)
        {      
            rxTlcPtr = 0;
            for (int i = 0; i < packet; i++)
            {
                rx_TLC[i] = '\0';
                data_TLC[i] = '\0';
            }
            
            spacecraft.printf(" .... Telecomando non inviato: timeout, riprovare! \n\r");
        } // end-else-if:telecommand+timeout   
    } // end-while:true
} // end-Main


/* ************************************************************* */
/* ******** SYSTEM INTERRPUTS MANAGEMENT AND FUNCTIONS ********* */
/* ************************************************************* */

// Interrupt: DORA receives a byte from Spacecraft
void RxTelecommand()
{
    char txChar;
    while (spacecraft.readable()) 
    { 
        txChar = spacecraft.getc();
        rx_TLC[rxTlcPtr++] = txChar;
    }
}

// Interrupt: DORA receives a byte from MIMA
void RxTelemetry()
{
    char rxChar;
    while (mima.readable()) 
    { 
        rxChar = mima.getc();
        
        if (tlmode_tlm == 0) // Standard telemetry message
        {
            rx_TLM[rxTlmPtr++] = rxChar;
        }
        else if (tlmode_option_1 == 0) // TLMODE 1 (all housekeeping telemetries)
        {
            rx_TLMOpt1[rxTlmOpt1Ptr++] = rxChar;
        }
        else if (tlmode_option_2 == 0) // TLMODE 2 (hsk+scientific data)
        {
            rx_TLMOpt2[rxTlmOpt2Ptr++] = rxChar;
        }
    }
}

// Once received a full telecommand frame, send it to MIMA
void TxTelecommand()
{
    mima.puts(data_TLC);
    TlcSend = true;
}

// Once received a full telemetry frame, send it to Spacecraft
void TxTelemetry()
{
    if (tlmode_tlm == 0)
    {
        spacecraft.puts(data_TLM);
    }
    else if (tlmode_option_1 == 0)
    {
        spacecraft.puts(data_TLMOpt1);
    }
    else if (tlmode_option_2 == 0)
    {
        spacecraft.puts(data_TLMOpt2);
    }
}

// Reset
void clearBuffer(char *arr, int arrLen)
{
    int myIndex;
    for (myIndex = 0; myIndex < arrLen; myIndex++)
    {
        arr[myIndex] = '\0'; // terminatore
    }
}