#include "mbed.h"
#include "ContinuousServo.h"
#include "Tach.h"
#include "TCS3472_I2C.h"

// color sensor
PwmOut LB(p22); //PWM out signal to power LED on teh sensor
TCS3472_I2C rgb_sensor(p9, p10); // Establish RGB sensor object
Serial pc(USBTX,USBRX); //Establish serial connection
int rgb_data[4]; //store sensor readings

//lights for colors
DigitalOut red(LED1);
DigitalOut green(LED2);
DigitalOut blue(LED3);
//DigitalOut magnet(LED4);

ContinuousServo left(p23);
ContinuousServo right(p26);

//encoders
Tach tLeft(p17,64);
Tach tRight(p13,64);

int main()
{ 
    rgb_sensor.enablePowerAndRGBC(); //Enable RGB sensor
    rgb_sensor.setIntegrationTime(100); //Set integration time of sensor
    
    pc.baud(9600); //set baud rate
    float PWMbrightness = 1.0; //float specifying brightness of LED (between 0.0 and 1.0)
    
    while(1) {
        
        left.speed(0.1);
        right.speed(-0.105); //right negative to go forward
        
        
        LB = PWMbrightness; //set brightness of sensor LED
        rgb_sensor.getAllColors(rgb_data);
        
        if(rgb_data[0] > 1000 && rgb_data[0]<5000){
            left.speed(0.3);
            right.speed(-0.305);
            }
         if (rgb_data[0]>5000)
         { left.speed(0.35);
            right.speed(-0.3);
            }
        if(rgb_data[0] < 1000)
        { left.speed(0.25);
          right.speed(-0.35);
          } 
        
        
        
        
        
        if ((rgb_data[0] > 10000))
        {
            blue = 0;
            green = 0;
            red = 0;
        }
        
        else if ((rgb_data[1] > rgb_data[2]) && (rgb_data[1] > rgb_data[3]) )
        {
            red = 1;
            green = 0;
            blue = 0;
        }
        else if ((rgb_data[2] > rgb_data[1]) && (rgb_data[2] > rgb_data[3]) )
        {
            if(rgb_data[2] > 1100)
            {
            green = 1;
            red = 0;
            blue = 0;
            }
            else
            {
            green = 0;
            red = 0;
            blue = 0;  
            }
        }
        else if ((rgb_data[3] > rgb_data[2]) && (rgb_data[3] > rgb_data[1]) )
        {
            blue = 1;
            green = 0;
            red = 0;
        }
        
        pc.printf("unfiltered: %d, red: %d, green: %d, blue: %d \n", rgb_data[0], rgb_data[1], rgb_data[2], rgb_data[3]);
     
}  //while
}  //main