/*============================================================================
 mbed_S9132_stream04
    Read out data from Hamamatsu S9132 Profile sensor
    and stream data to computer through serial usb
 Visarute Pinrod
 SonicMEMS Laboratory, ECE, Cornell University, Ithaca, NY, USA
 August 20, 2015 
============================================================================*/

#include "mbed.h"
#include "FastIO.h"

FastOut<p23> stC;
FastOut<p24> clkC;
FastIn<p25> eosX;
FastIn<p26> trigX;
FastIn<p27> eocX;
FastIn<p28> doY;
FastIn<p29> doX;
FastIn<p30> trigY;

//DigitalOut stC(p23);
//DigitalOut clkC(p24);
//DigitalIn eosX(p25);
//DigitalIn trigX(p26);
//DigitalIn eocX(p27);
//DigitalIn doY(p28);
//DigitalIn doX(p29);
//DigitalIn trigY(p30);
// DigitalOut myled(LED1);

// Object
Serial pc(USBTX, USBRX); // tx, rx

void initial(){
    pc.baud(460800);
    //pc.baud(921600);
    stC=1;
    clkC= 0;
}

void readS9132() {
    short i=0;
    short x[256] = {0};
    short y[256] = {0};
    for(i=0;i<256;i++){
        x[i]=0xEA6;
        y[i]=0xEA6;
    }
    char eoc=2;
    char bit=11;
    short xp = 0;
    short yp = 0;
    char xo = 0;
    char yo = 0;
    short pxi=0;
    stC=1;
    clkC= 0;
    stC=0;
    wait_us(1);
    clkC= 1;
    wait_us(1);
    clkC= 0;
    wait_us(1);
    clkC= 1;
    wait_us(1);
    clkC= 0;
    wait_us(1);
     
     wait_us(1);
    stC=1;
    //pc.printf("\n\n      ========= Restart MBED =========      \n\n");
    for(i=0;i<3200;i++) {
        //pc.printf(" i = %d ",i);
        clkC= 1;
        wait_us(1);
        /*pc.printf(" trigX ");
        if (trigX.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }
        pc.printf(" trigY ");
        if (trigY.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }*/
        clkC= 0;
        wait_us(1);
        //pc.printf(" eoc ");
        if (eocX.read() == 1){
            //pc.printf("1");
            eoc=1;
        }else{
            //pc.printf("0");
            eoc=0;
        }
        /*pc.printf(" eos ");
        if (eosX.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }
        pc.printf(" doX ");*/
        if (doX.read() == 1){
            //pc.printf("1");
            xo=1;
        }else{
            //pc.printf("0");
            xo=0;
        }
        //pc.printf(" doY ");
        if (doY.read() == 1){
            //pc.printf("1");
            yo=1;
        }else{
            //pc.printf("0");
            yo=0;
        }
        
        /*pc.printf(" trigX ");
        if (trigX.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }
        pc.printf(" trigY ");
        if (trigY.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }
        pc.printf("\n");
        */
        
        if(eoc==0){
            bit--;
            if(bit<10){
                xp=xp<<1|xo;
                yp=yp<<1|yo;
            }
            if(bit==0){
                bit=11;
                x[pxi]=xp;
                y[pxi]=yp;
                pxi++;
                //pc.printf("pxi= %d, x = %03X, y = %03X\n",pxi,xp,yp);
                wait_us(1);
                xp=0;
                yp=0;
                
            }
        }
    }
    pc.printf("[CAM_READ_ST]");
    for(i=0;i<256;i++){
        pc.printf("%03X%03X",x[i],y[i]);
        //pc.printf(" i= %d, x = %03X, y = %03X\n",i,x[i],y[i]);
    }
    pc.printf("[CAM_READ_ED]\n");
}

void flushS9132() {
    short i=0;
    short x[256] = {0};
    short y[256] = {0};
    for(i=0;i<256;i++){
        x[i]=0xEA6;
        y[i]=0xEA6;
    }
    char eoc=2;
    char bit=11;
    short xp = 0;
    short yp = 0;
    char xo = 0;
    char yo = 0;
    short pxi=0;
    stC=1;
    clkC= 0;
    stC=0;
    wait_us(1);
    clkC= 1;
    wait_us(1);
    clkC= 0;
    wait_us(1);
    clkC= 1;
    wait_us(1);
    clkC= 0;
    wait_us(1);
     
     wait_us(1);
    stC=1;
    //pc.printf("\n\n      ========= Restart MBED =========      \n\n");
    for(i=0;i<3200;i++) {
        //pc.printf(" i = %d ",i);
        clkC= 1;
        wait_us(1);
        /*pc.printf(" trigX ");
        if (trigX.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }
        pc.printf(" trigY ");
        if (trigY.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }*/
        clkC= 0;
        wait_us(1);
        //pc.printf(" eoc ");
        if (eocX.read() == 1){
            //pc.printf("1");
            eoc=1;
        }else{
            //pc.printf("0");
            eoc=0;
        }
        /*pc.printf(" eos ");
        if (eosX.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }
        pc.printf(" doX ");*/
        if (doX.read() == 1){
            //pc.printf("1");
            xo=1;
        }else{
            //pc.printf("0");
            xo=0;
        }
        //pc.printf(" doY ");
        if (doY.read() == 1){
            //pc.printf("1");
            yo=1;
        }else{
            //pc.printf("0");
            yo=0;
        }
        
        /*pc.printf(" trigX ");
        if (trigX.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }
        pc.printf(" trigY ");
        if (trigY.read() == 1){
            pc.printf("1");
        }else{
            pc.printf("0");
        }
        pc.printf("\n");
        */
        
        if(eoc==0){
            bit--;
            if(bit<10){
                xp=xp<<1|xo;
                yp=yp<<1|yo;
            }
            if(bit==0){
                bit=11;
                x[pxi]=xp;
                y[pxi]=yp;
                pxi++;
                //pc.printf("pxi= %d, x = %03X, y = %03X\n",pxi,xp,yp);
                wait_us(1);
                xp=0;
                yp=0;
                
            }
        }
    }
}

int main(){
    // Variable for main function
    char buf[16];       // Buffer for the command from PC
    initial();
    while(1) {
        flushS9132();
        if (pc.readable()) {
            //Command format: Start Mode Submode VALUe enD   S F F FFFF D
            pc.gets(buf, 16);
            //pc.printf("Get buf: %s\n",buf);
            if ((buf[0] == 'S')&&(buf[7] == 'D')) {
                //Mode switch
                switch(buf[1]) { 
                //read all axis mode
                case 'c': 
                    // camera
                    switch(buf[2]) { 
                    case 'o':
                        readS9132();
                        break;
                    default:
                        break;
                    }
                default:
                    break;
                }
            }
        }     
    }
    return 0;
}