#include "mbed.h"

DigitalOut realy_switch_impedance_p(p5), realy_switch_impedance_n(p6);
DigitalOut relay_switch_drive_p(p7), relay_switch_drive_n(p8);
DigitalOut relay_switch_ch1_p(p21), relay_switch_ch1_n(p22);
DigitalOut relay_switch_ch2_p(p23), relay_switch_ch2_n(p24);
DigitalOut relay_switch_ch3_p(p25), relay_switch_ch3_n(p26);
DigitalOut relay_switch_ch4_p(p27), relay_switch_ch4_n(p28);

Serial pc(USBTX, USBRX);
DigitalOut myled1(LED1), myled2(LED2), myled3(LED3), myled4(LED4);

unsigned int asciitoint(char c);

// get the one digit function
unsigned int onedigit(char c0){
    unsigned int k0 = asciitoint(c0);
    //unsigned int kall = k3 + k2 + k1 + k0;
    return k0;
}

int main() {
    char buffer[128];

    while(true) {       
        // get command from PC
        if (pc.readable()){    
            //input format:
            //SWT A \n \0
            //no spaces
            //A is the swtiching case
            //for some reason the mBed can only take even number of string
            pc.gets(buffer, 5);

        if ((buffer[0] == 'S')&&(buffer[1] == 'W')&&(buffer[2] == 'T')){
                myled1= !myled1;
                //convert buffer[3] into integer
                unsigned int case_num = onedigit(buffer[3]);
        
            ///////////////////////////////////////////////////////////
            //switching cases
            //1: both trun off
            //2: impedacne analyzer
            //3: PZT drive
            //default: both turn off        
            ///////////////////////////////////////////////////////////
            switch (case_num){
                case (1): // all off
                    realy_switch_impedance_p = 0;
                    realy_switch_impedance_n = 0;
                    relay_switch_drive_p = 0;
                    relay_switch_drive_n = 0;
                    relay_switch_ch1_p = 0;
                    relay_switch_ch1_n = 0;
                    relay_switch_ch2_p = 0;
                    relay_switch_ch2_n = 0;
                    relay_switch_ch3_p = 0;
                    relay_switch_ch3_n = 0;
                    relay_switch_ch4_p = 0;
                    relay_switch_ch4_n = 0;
                    //case(000)
                    myled2 = 0;
                    myled3 = 0;
                    myled4 = 0;
          
                    wait(2);
                    break;      
                case (2): // impedance analyzer
                    realy_switch_impedance_p = 1;
                    realy_switch_impedance_n = 1;
                    relay_switch_drive_p = 0;
                    relay_switch_drive_n = 0;
                    relay_switch_ch1_p = 0;
                    relay_switch_ch1_n = 0;
                    relay_switch_ch2_p = 0;
                    relay_switch_ch2_n = 0;
                    relay_switch_ch3_p = 0;
                    relay_switch_ch3_n = 0;
                    relay_switch_ch4_p = 1;
                    relay_switch_ch4_n = 1;
                    //case(111)
                    myled2 = 0;
                    myled3 = 0;
                    myled4 = 1;
                                        
                    wait(2);
                    break;      
                case (3): //drive only
                    realy_switch_impedance_p = 0;
                    realy_switch_impedance_n = 0;
                    relay_switch_drive_p = 1;
                    relay_switch_drive_n = 1;
                    relay_switch_ch1_p = 0;
                    relay_switch_ch1_n = 0;
                    relay_switch_ch2_p = 0;
                    relay_switch_ch2_n = 0;
                    relay_switch_ch3_p = 0;
                    relay_switch_ch3_n = 0;
                    relay_switch_ch4_p = 0;
                    relay_switch_ch4_n = 0;
                    //case(111)
                    myled2 = 0;
                    myled3 = 1;
                    myled4 = 0;
                                        
                    wait(2);
                    break;      
                case(4): //drive and channel 1
                    realy_switch_impedance_p = 0;
                    realy_switch_impedance_n = 0;
                    relay_switch_drive_p = 1;
                    relay_switch_drive_n = 1;
                    relay_switch_ch1_p = 1;
                    relay_switch_ch1_n = 1;
                    relay_switch_ch2_p = 0;
                    relay_switch_ch2_n = 0;
                    relay_switch_ch3_p = 0;
                    relay_switch_ch3_n = 0;
                    relay_switch_ch4_p = 0;
                    relay_switch_ch4_n = 0;
                    //case(111)
                    myled2 = 0;
                    myled3 = 1;
                    myled4 = 1;
                                        
                    wait(2);
                    break;      
                case(5): //drive and channel 2
                    realy_switch_impedance_p = 0;
                    realy_switch_impedance_n = 0;
                    relay_switch_drive_p = 1;
                    relay_switch_drive_n = 1;
                    relay_switch_ch1_p = 0;
                    relay_switch_ch1_n = 0;
                    relay_switch_ch2_p = 1;
                    relay_switch_ch2_n = 1;
                    relay_switch_ch3_p = 0;
                    relay_switch_ch3_n = 0;
                    relay_switch_ch4_p = 0;
                    relay_switch_ch4_n = 0;
                    //case(111)
                    myled2 = 1;
                    myled3 = 0;
                    myled4 = 0;
                                        
                    wait(2);
                    break;                      
                case(6): //drive and channel 3
                    realy_switch_impedance_p = 0;
                    realy_switch_impedance_n = 0;
                    relay_switch_drive_p = 1;
                    relay_switch_drive_n = 1;
                    relay_switch_ch1_p = 0;
                    relay_switch_ch1_n = 0;
                    relay_switch_ch2_p = 0;
                    relay_switch_ch2_n = 0;
                    relay_switch_ch3_p = 1;
                    relay_switch_ch3_n = 1;
                    relay_switch_ch4_p = 0;
                    relay_switch_ch4_n = 0;
                    //case(111)
                    myled2 = 1;
                    myled3 = 0;
                    myled4 = 1;
                                        
                    wait(2);
                    break;      
                case(7): //drive and channel 4
                    realy_switch_impedance_p = 0;
                    realy_switch_impedance_n = 0;
                    relay_switch_drive_p = 1;
                    relay_switch_drive_n = 1;
                    relay_switch_ch1_p = 0;
                    relay_switch_ch1_n = 0;
                    relay_switch_ch2_p = 0;
                    relay_switch_ch2_n = 0;
                    relay_switch_ch3_p = 0;
                    relay_switch_ch3_n = 0;
                    relay_switch_ch4_p = 1;
                    relay_switch_ch4_n = 1;
                    //case(111)
                    myled2 = 1;
                    myled3 = 1;
                    myled4 = 0;
                                        
                    wait(2);
                    break;                
                default: //default: impedance only
                    realy_switch_impedance_p = 1;
                    realy_switch_impedance_n = 1;
                    relay_switch_drive_p = 0;
                    relay_switch_drive_n = 0;
                    relay_switch_ch1_p = 0;
                    relay_switch_ch1_n = 0;
                    relay_switch_ch2_p = 0;
                    relay_switch_ch2_n = 0;
                    relay_switch_ch3_p = 0;
                    relay_switch_ch3_n = 0;
                    relay_switch_ch4_p = 0;
                    relay_switch_ch4_n = 0;                    
                    // case(000)
                    myled2 = 0;
                    myled3 = 0;
                    myled4 = 0;

                    wait(2);
                    break;
                }// end of the case
            }// end of the buffer read
        }//end of the pc read
    }// end of while
}// end of main()

// change the ascii into interger function
unsigned int asciitoint(char c){
    unsigned int i;
    i = 0;
    switch(c){
        case 0x20: i = 0; break;
        case '0' : i = 0; break;
        case '1' : i = 1; break;
        case '2' : i = 2; break;
        case '3' : i = 3; break;
        case '4' : i = 4; break;
        case '5' : i = 5; break;
        case '6' : i = 6; break;
        case '7' : i = 7; break;
        case '8' : i = 8; break;
        case '9' : i = 9; break;
        default: i = 0; break;
    }
    return i;
}