#include "mbed.h"

Serial pc(USBTX, USBRX);    //creates serial line to talk with matlab
BusIn ADC(p20, p19, p18, p17, p16, p15, p14, p13);  //creates a bus input to take in ADC value
int dataIn[400];    //data storage array
DigitalOut myled(LED1); //heartbeat led for data acquisition
int buf[128];   //code execution data array

int main(){
    if (pc.readable()) {
            //WAV 0 END \n \0
            //use buf[3] as a 0 just as a parity bit
            pc.gets(buf, 16);
            if ((buf[0] == 'W')&&(buf[1] == 'A')&&(buf[2] == 'V')&&(buf[4] == 'E')&&(buf[5] == 'N')&&(buf[6] == 'D')) {
                ADC.mode(PullNone);  //sets the mode to pull none
                for(int i = 0; i < 400; i++){   //acquires ADC values for 400 data points with 2 ms delays
                    myled = 1;
                    wait(0.001);
                    myled = 0;
                    wait(0.001);  //gives delay prior to each reading to ensure different values
                    dataIn[i] = ADC.read();
                }
                for(int i = 0; i < 400; i++){   //prints data point values to computer
                    printf("ADC value is %d\n\r", dataIn[i]);
                }
                
            } // end of if( buffer read)
        } // end of if(pc.readable())
        
    return 1;
    
}