/////////////////////////////////////////////////////////////////////////
// AD9833 control code
// Create by Po-Cheng Chen 07-04-2014
// Version 0.1
/////////////////////////////////////////////////////////////////////////

#include "mbed.h"
#include "SPI.h"
#include "DigitalOut.h"

SPI AD9833_SPI(p5, p6, p7); //mosi, miso, sclk --> don't need MISO
DigitalOut fSync(p8); //use p8 as FSync data pin (same as chip select)

/////////////////////////////////////////////////////////////////////////
// SPI initialization
/////////////////////////////////////////////////////////////////////////
void SPI_INITIALIZATION()
{
    //Setup the spi for 16 bit data, with 25MHz clock rate, mode 2
    // Note: mBed is MSB first SPI protocol
    AD9833_SPI.format(16,2);
    AD9833_SPI.frequency(25000000);
    fSync = 1;
    wait_ms(10);
}
/////////////////////////////////////////////////////////////////////////
// SPI writing
/////////////////////////////////////////////////////////////////////////
void write_SPI(short dat)
{
    fSync = 0;
    AD9833_SPI.write(dat);
    fSync = 1;
}
/////////////////////////////////////////////////////////////////////////
// Set desired frequency
// Comments:Calculate the desired frequency accrodingly
//          Do it in Matlab or mBed?
/////////////////////////////////////////////////////////////////////////
void setFreq(long FREQ)
{
    int freq_MSB;   //define freq MSB reg value
    int freq_LSB;   //define freq LSB reg value
    
    long freq_cal;  //define freq calculated value
    float freq_val = 0.00000000;    //define ferq calculate tempotary value
    
    //calculate the frqe reg value
    //((desired frequency)/(reference frequency)) x 0x10000000.
    freq_val = (((float)(frequency))/25000000);
    freq_cal = freq_val*0x10000000;
    
    freq_MSB = (int)((freq_cal & 0xFFFC000)>>14); // shift 14 bits
    freq_LSB = (int)(freq_cal & 0x3FFF);
    
    freq_MSB = freq_MSB | 0x4000;  //assign freq reg address
    freq_LSB = freq_LSB | 0x4000;
    ///////////////////////////////////////////////////////////////////////////////////    
    //print the data from the serial port to verifiy the function
    printf("freq_LSB 0x%x\n\r", freq_LSB);
    //print the data from the serial port to verifiy the function
    printf("freq_MSB 0x%x\n\r", freq_MSB);
    ///////////////////////////////////////////////////////////////////////////////////
    write_SPI(0x2100);      //write control reg - apply reset
    write_SPI(freq_LSB);    //write freq reg - LSB
    write_SPI(freq_MSB);    //write freq reg - MSB
    write_SPI(0xC000);      //write phase reg - 0 for now
    write_SPI(0x2000);      //write control reg - disable reset
}

/////////////////////////////////////////////////////////////////////////
// Main function
// Comments:include the command line from Matlab
//          Control from COM port
/////////////////////////////////////////////////////////////////////////
int main()
{
    SPI_INITIALIZATION(); // initialized the SPI
    setFreq(100000);
}