#include "mbed.h"

SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);
 
int main() {
    // Chip must be deselected
    
    cs = 1;
    spi.format(16,0);
    spi.frequency(1000000);

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    while(1){
    // Select the device by seting chip select low
    cs = 0;
 
    // Send 0x8f, the command to read the WHOAMI register
    //spi.write(0x8F);
 
    // Send a dummy byte to receive the contents of the WHOAMI register
    unsigned int whoami = spi.write(0x00);
    whoami = (whoami>>1)&0x0FFF;
    printf("WHOAMI register = %d\n\r", whoami);
 
    // Deselect the device
    cs = 1;
    //wait(0.001);
    }
}