/////////////////////////////////////////////////////////////////////////
// AD9833 control code
// Create by Po-Cheng Chen 07-04-2014
// Version 0.2 (MATLAB)
/////////////////////////////////////////////////////////////////////////

#include "mbed.h"
#include "SPI.h"
#include "DigitalOut.h"

SPI AD9833_SPI(p5, p6, p7); //mosi, miso, sclk --> don't need MISO
DigitalOut fSync(p8); //use p8 as FSync data pin (same as chip select)

Serial pc(USBTX, USBRX);    //define serial USB port
DigitalOut myled1(LED1), myled2(LED2), myled3(LED3), myled4(LED4); //define LEDs

/////////////////////////////////////////////////////////////////////////
// ASCII to Interger function
/////////////////////////////////////////////////////////////////////////
unsigned int ascii2int(char c)
{
    unsigned int i;
    i = 0;
    switch(c) {
        case 0x20:
            i = 0;
            break;
        case '0' :
            i = 0;
            break;
        case '1' :
            i = 1;
            break;
        case '2' :
            i = 2;
            break;
        case '3' :
            i = 3;
            break;
        case '4' :
            i = 4;
            break;
        case '5' :
            i = 5;
            break;
        case '6' :
            i = 6;
            break;
        case '7' :
            i = 7;
            break;
        case '8' :
            i = 8;
            break;
        case '9' :
            i = 9;
            break;
        default:
            i = 0;
            break;
    }
    return i;
}
/////////////////////////////////////////////////////////////////////////
// 8 digit function
/////////////////////////////////////////////////////////////////////////
unsigned int digit8(char c7, char c6, char c5, char c4,
                    char c3, char c2, char c1, char c0)
{
    unsigned int k7 = 10000000*ascii2int(c7);
    unsigned int k6 = 1000000*ascii2int(c6);
    unsigned int k5 = 100000*ascii2int(c5);
    unsigned int k4 = 10000*ascii2int(c4);
    unsigned int k3 = 1000*ascii2int(c3);
    unsigned int k2 = 100*ascii2int(c2);
    unsigned int k1 = 10*ascii2int(c1);
    unsigned int k0 = ascii2int(c0);
    unsigned int k = k7 + k6 + k5 + k4 + k3 + k2 + k1 + k0;
    return k;
}
/////////////////////////////////////////////////////////////////////////
// SPI initialization
/////////////////////////////////////////////////////////////////////////
void SPI_INITIALIZATION()
{
    //Setup the spi for 16 bit data, with 25MHz clock rate, mode 2
    // Note: mBed is MSB first SPI protocol
    AD9833_SPI.format(16,2);
    AD9833_SPI.frequency(25000000);
    fSync = 1;
    wait_ms(10);
}
/////////////////////////////////////////////////////////////////////////
// SPI writing
/////////////////////////////////////////////////////////////////////////
void write_SPI(short dat)
{
    fSync = 0;
    AD9833_SPI.write(dat);
    fSync = 1;
}
/////////////////////////////////////////////////////////////////////////
// Calculate desired frequency
/////////////////////////////////////////////////////////////////////////
long calFreq(long freq)
{
    long  freq_cal;  //define freq calculated value
    float freq_val = 0.00000000;    //define ferq calculate tempotary value
    
    //calculate the frqe reg value
    //((desired frequency)/(reference frequency)) x 0x10000000.
    freq_val = (((float)(freq))/25000000);
    freq_cal = freq_val*0x10000000;
    return freq_cal;
}
/////////////////////////////////////////////////////////////////////////
// Set frequency register
/////////////////////////////////////////////////////////////////////////
void setFreq(long frequency)
{   
    int freq_MSB;   //define freq MSB reg value
    int freq_LSB;   //define freq LSB reg value
    
    long freq_cal = calFreq(frequency); //calculate the frequency register
    
    freq_MSB = (int)((freq_cal & 0xFFFC000)>>14); // shift 14 bits
    freq_LSB = (int)(freq_cal & 0x3FFF);
    
    freq_MSB = freq_MSB | 0x4000;  //assign freq reg address
    freq_LSB = freq_LSB | 0x4000;
    ///////////////////////////////////////////////////////////////////////////////////    
    //print the data from the serial port to verifiy the function
    //printf("freq_LSB 0x%x\n\r", freq_LSB);
    //printf("freq_MSB 0x%x\n\r", freq_MSB);
    ///////////////////////////////////////////////////////////////////////////////////
    write_SPI(0x2100);      //write control reg - apply reset
    write_SPI(freq_LSB);    //write freq reg - LSB
    write_SPI(freq_MSB);    //write freq reg - MSB
    write_SPI(0xC000);      //write phase reg - (0 for now)
    write_SPI(0x2000);      //write control reg - disable reset
}

/////////////////////////////////////////////////////////////////////////
// Main function
// Comments:include the command line from Matlab
//          Control from COM port
/////////////////////////////////////////////////////////////////////////
int main()
{
    char buf[128];     // assign buffer for the command from PC
    SPI_INITIALIZATION(); // initialized the SPI
    while(true) {
        if (pc.readable()) {
            //WAV AAAA BBBB CCCC DDDD EEEE FFFF GGGG HHHH END \n \0
            //A, B, C, D ,E, F, G, H are frequency numbers
            //need 3 + (32) + 3 + 1 + 1 = 40
            pc.gets(buf, 16);
            if ((buf[0] == 'W')&&(buf[1] == 'A')&&(buf[2] == 'V')&&(buf[11] == 'E')&&(buf[12] == 'N')&&(buf[13] == 'D')) {
                myled1 = !myled1;
                int freq_pc = digit8(buf[3], buf[4], buf[5], buf[6], buf[7], buf[8], buf[9], buf[10]);
                setFreq(freq_pc);
                
            } // end of if( buffer read)
        } // end of if(pc.readable())        
    }// end of while()
} // end of main()