#include "mbed.h"
#include "Memory.h"
#define TNF 0x02
#define TFE 0x01
#define RNE 0x04

Memory::Memory(PinName chipSelect) : _cs_mem(chipSelect)
{
    _cs_mem=1;
}
/**
 * Reads 'length' elements into a char array starting at the 24bit Address.
 *If length is greater than BufferSize (3840 bytes) the function will terminate
 *and return the start address.
 */
/*** My method to mywrite to FeRAM ***/
void MEMmywrite (unsigned char data) {
    // First don't mywrite to the FIFO buffer if it is full
    while (!(LPC_SSP0->SR & TNF))       // While TNF-Bit = 0 (FIFO full)...
        ;                               // Wait
    LPC_SSP0->DR = data;                // mywrite to FIFO buffer
}

int Memory::readData(short value [], int Address, int length)
{
    //if(length>bufferSize) {
        //printf("\nLength %i exceeds Max Length\n",length);
        //return Address;
    //}
    int temp = 0;
    int temp1 = 0;
    int temp2 =0;
    _cs_mem = 1;             //Ensure cs is deselected
    wait_us(10);
    _cs_mem = 0;                     //memory is selected
    MEMmywrite(0x03);         //Send read command
    MEMmywrite(Address>>16);  //Send high address byte
    MEMmywrite(Address>>8);   //Send mid address byte
    MEMmywrite(Address);      //Send low address byte


    for(int i =0; i <length; i++) {
        MEMmywrite(dummy);//Send dummy byte to read out value ate Address
        while (LPC_SSP0->SR & RNE)
            temp = LPC_SSP0->DR;
        value[i]= (temp);
        //printf(" %X",value[i]);
        Address++;
    }
    _cs_mem = 1;
    return Address;     //Return the address of the next unread byte
}


/**
 * Sector  Erase, erases everything in the 4KB sector that includes Address
 */
void Memory::sectorErase(long Address)
{
    int byte1 = 1;
    _cs_mem = 1;
    _cs_mem=0;
    MEMmywrite(0x06);     //Send Write enable command
    _cs_mem= 1;
    wait_us(5);
    _cs_mem=0;
    MEMmywrite(0x20);     //Send sector erase comand
    MEMmywrite(Address>>16);  //Send high address byte
    MEMmywrite(Address>>8);   //Send mid address byte
    MEMmywrite(Address);      //Send low address byte
    _cs_mem=1;
    wait_us(5);

    //Pol the status register untill the Write In Progress bit is no longer set
    _cs_mem=0;
    MEMmywrite(05);
    MEMmywrite(dummy);
    while (LPC_SSP0->SR & RNE)          // While RNE-Bit = 1 (FIFO receive buffer not empty)...
        byte1 = LPC_SSP0->DR;
    while(byte1>0) {
        MEMmywrite(dummy);
        while (LPC_SSP0->SR & RNE)          // While RNE-Bit = 1 (FIFO receive buffer not empty)...
            byte1 = LPC_SSP0->DR;
    }
    _cs_mem=1;
}


/**
 * Block  Erase, erases everything in a 4KB block that includes Address
 */
int Memory::blockErase(int Address)
{
    int byte1 = 1;
    _cs_mem = 1;
    _cs_mem=0;
    MEMmywrite(0x06);     //Send Write enable command
    _cs_mem= 1;
    wait_us(5);
    _cs_mem=0;
    MEMmywrite(0xD8);     //Send sector erase comand
    MEMmywrite((Address>>16)&0xff);  //Send high address byte
    MEMmywrite((Address>>8)&0xff);   //Send mid address byte
    MEMmywrite((Address)&0xff);      //Send low address byte
    _cs_mem=1;
    wait_us(5);

    //Pol the status register untill the Write In Progress bit is no longer set
    _cs_mem=0;
    MEMmywrite(05);
    MEMmywrite(dummy);
    while (LPC_SSP0->SR & RNE)          // While RNE-Bit = 1 (FIFO receive buffer not empty)...
        byte1 = LPC_SSP0->DR;
    while(byte1>0) {
        MEMmywrite(dummy);
        while (LPC_SSP0->SR & RNE)          // While RNE-Bit = 1 (FIFO receive buffer not empty)...
            byte1 = LPC_SSP0->DR;
    }
    _cs_mem=1;
    int returnVal = (Address/0x10000);
    returnVal*=0x10000;
    returnVal+=0x10000;
    return returnVal;
}

/**
 * Writes a char array containg 'length' elements to memory sarting at address.
 *If length is greater than BufferSize (3840 bytes) the function will terminate
 *and return the start address.
 */
int Memory::writeData(char buffer[], int address, int length)
{
    int byte1 = 1;
    //printf("\n C0 ");
    if(length>bufferSize) {
        printf("\nLength %i exceeds Max Length\n",length);
        return address;
    }
    //printf("\n C1 ");
    for(int i =0; i<length; i++) {
        if(address%256==0) {                //Handle start and end of pages
            _cs_mem=1;
            wait_us(10);
            //printf("\n C2 ");
            
            //wait for the WIP bit to go low
            _cs_mem=0;                           //Selet memory
            MEMmywrite(0x05);             //Send read status register command
            MEMmywrite(dummy);
            while (LPC_SSP0->SR & RNE)          // While RNE-Bit = 1 (FIFO receive buffer not empty)...
                byte1 = LPC_SSP0->DR;
            //printf("\n C3 ");
            while ((byte1&1)>0) {
                wait_us(10);
                printf("\n C4 ");
                MEMmywrite(0x05);         //Send read status register command
                MEMmywrite(dummy);
                while (LPC_SSP0->SR & RNE)          // While RNE-Bit = 1 (FIFO receive buffer not empty)...
                    byte1 = LPC_SSP0->DR;
            }
            _cs_mem=1;

            _cs_mem=0;                           //Selet memory
            MEMmywrite(06);               //Set Write Enable flag in the status reg
            _cs_mem=1;
            wait_us(10);
            
            //printf("\n C5 ");
            _cs_mem=0;                           //Selet memory
            MEMmywrite(02);               //Send read comand
            MEMmywrite(address>>16);      //Send high address byte
            MEMmywrite(address>>8);       //Send middle adress byte
            MEMmywrite(address);          //Send low address

        }
        //printf("\n C6 ");
        MEMmywrite(buffer[i]);            //Write the calue of the buffer to memory
        //printf("%i%i%i%i%i%i%i%i",sixtyBytes[i]>>7&&1,buffer[i]>>6&&1,buffer[i]>>5&&1,buffer[i]>>4&&1,buffer[i]>>3&&1,buffer[i]>>2&&1,buffer[i]>>1&&1,buffer[i]&&1);
            
        wait_us(5);
        address=address++;                  //Increment address
    }
    _cs_mem=1;
    return address;
}


