#include "LPC4088-ioconfig.h"
#include "LPC4088-system.h"
#include "LPC4088-gpio.h"
#include "LPC4088-adc.h"

int main(){

    //nastavitev P1.13 kot GPIO, no pull-up, no hysteresis, not inverted, standard, push-pull
    IOCON_P1_13 &= !(0x67F);

    //pin P1.31 skonfiguriramo kot vhod ADC[5]
    IOCON_P1_31 |= 0x3;
    
    //pin P1.31 skonfiguriramo kot no pullup/pulldown
    IOCON_P1_31 &= !(0x3<<4);
    
    //pin P1.31 skonfiguriramo za ADMODE
    IOCON_P1_31 &= !(1<<7);

    //pin P0.23 skonfiguriramo kot vhod ADC[0]
    IOCON_P0_23 |= 0x3;
    
    //pin P0.23 skonfiguriramo kot no pullup/pulldown
    IOCON_P0_23 &= !(0x3<<4);
    
    //pin P0.23 skonfiguriramo za ADMODE
    IOCON_P0_23 &= !(1<<7); 
    
    
    
    //vklop GPIO periferije (nepotrebno)
    PCONP |= (1<<15);    

    //nastavitev P1.13 kot output
    DIR1 |= (1<<13);
    
    //nastavitev P1.13 maske
    MASK1 &= !(1<<13);





    //vklop ADC periferije 
    PCONP |= (1<<12);
    
    //PCLK delimo z 99+1=100
    //CR |= (99<<8);
    
    //izklopimo ADC interrupte
    INTEN &= !(0x1FF);
    
    //pred izbiro "burst mode" moramo izklopiti konverzijo
    CR &= !(0x7<<24);
    
    //izberemo "burst mode" - konverzija se stalno vrši
    //CR |= (1<<16);

    //izberemo "software mode" - konverzija se vrši na ukaz
    CR &= !(1<<16);

    //izberemo, kateri kanal bomo brali
    //CR |= (1<<5);
    //CR &= !(1<<0);

    
    while(1){

        //vklopimo ADC (moramo vklopiti po nastavitvah)
        CR |= (1<<21);
        
        //zaženemo konverzijo
        CR |= (0x1<<24);
        
        //pocakamo na konec konverzije in shranimo rezultat
        while( (STAT & (1<<0) ) == 0x0 );
        
        //ustavimo konverzijo
        CR &= !(0x1<<24);
        
        unsigned int result = 0;
        result = ( (DR0 & 0xFFF0) >> 4); //this clears DONE bit

        //izklopimo ADC 
        CR &= (1<<21);      
        
        if (result > 0x7FF){
            //prizgemo P1.13
            SET1 |= (1<<13);
        }
        else{
            //ugasnemo P1.13
            CLR1 |= (1<<13);
        }
    }       
}

