//IOCONFIG peripheral
#define IOCON_P1_13     (*((volatile unsigned int *) 0x4002C0B4))

//system register
#define PCONP           (*((volatile unsigned int *) 0x400FC0C4)) 

//GPIO registers for port 1
#define DIR1            (*((volatile unsigned int *) 0x20098020))
#define MASK1           (*((volatile unsigned int *) 0x20098030))
#define PIN1            (*((volatile unsigned int *) 0x20098034))
#define SET1            (*((volatile unsigned int *) 0x20098038))
#define CLR1            (*((volatile unsigned int *) 0x2009803C))


//function prototypes
void delay(void);


int main() {
    
    //first three bits of the IOCON_P1_13 register are 000
    IOCON_P1_13 = (IOCON_P1_13 & !(0x7));
    
    //bits 3,4 of the IOCON_P1_13 are now 00 (no pullup/pulldown resistor)
    IOCON_P1_13 = (IOCON_P1_13 & !(0x3<<3));
    
    //disable hysteresis
    IOCON_P1_13 = (IOCON_P1_13 & !(0x1<<5));
    
    //disable inversion
    IOCON_P1_13 = (IOCON_P1_13 & !(0x1<<6));
    
    //use SLEW - standard mode
    IOCON_P1_13 = (IOCON_P1_13 & !(0x1<<9));
    
    //use normal push-pull operation
    IOCON_P1_13 = (IOCON_P1_13 & !(0x1<<10));
    
    
    
    
    
    //turn on GPIO peripheral (not really needed)
    PCONP = (PCONP | (1<<15));
    
    //make P1_13 an output GPIO
    DIR1 = (DIR1 | (1<<13));
    
    //disable mask for GPIO pin P1_13
    MASK1 = (MASK1 & !(1<<13));
    
    
    //an endless loop
    while(1){
        
        //turn on an LED
        SET1 = (SET1 | (1<<13));
        
        delay();
        
        //turn off an LED
        CLR1 = (CLR1 | (1<<13));  
        
        delay();
        
    }
       
}


//a delay function
void delay(void){
    
    volatile int time = 1000000;
    
    while(time){
        
        time = time - 1;
        
    }
}
