/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef WIFI_H
#define WIFI_H

#include "cc3000.h"

#define WIGO           1
#define WIFI_DIPCORTEX 2
#define UNDEFINED      3

#define MY_BOARD WIFI_DIPCORTEX

// use this defines in AP_SECURITY 
#define NONE 0
#define WEP  1
#define WPA  2
#define WPA2 3

// use smart config
#define USE_SMART_CONFIG    0

 // Default SSID Settings
#define SSID            "soldersplash"
#define AP_KEY          "wifidipcortex"
#define AP_SECURITY     WPA2 

void init();


#endif
