/**
 * USB to UART Bridge
 */
 
#include "mbed.h"
#include "USBSerial.h"
#include "DipCortex-EEprom.h"

// Serial TX Pin19, Serial RX Pin20
// Using port and pin names as the mbed definitions pin defs for the M0 are incorrect
Serial uart(P1_13, P1_14);
USBSerial pc;

// Called by ISR
void settingsChanged(int baud, int bits, int parity, int stop)
{
    const Serial::Parity parityTable[] = {Serial::None, Serial::Odd, Serial::Even, Serial::Forced0, Serial::Forced1};
    
    if (stop != 2) {
        stop = 1;   // stop bit(s) = 1 or 1.5
    }
    
    uart.baud(baud);
    uart.format(bits, parityTable[parity], stop);
}

int main()
{
volatile char charIn;
char tempBuf[15] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int i = 0;

    IAP_Init();
    pc.attach(settingsChanged);
    
    // wait for a key press
    charIn = pc.getc();
    
    while (1) 
    {
        pc.printf("Press a key to start\r\n");
        charIn = pc.getc();
        
        // Test read
        tempBuf[0] = 0;
        IAP_Eeprom_Read(1, (uint8_t *)&tempBuf, 15);
        pc.printf("EEprom Read : %s\r\n", &tempBuf[0]);
        
        // Write
        sprintf( &tempBuf[0], "Testing %i", i );
        IAP_Eeprom_Write(1, (uint8_t *)&tempBuf, 15);
        pc.printf("EEprom Writen : %s\r\n", &tempBuf[0]);
        
        tempBuf[0] = 0;
        pc.printf("Press a key to read back\r\n");
        charIn = pc.getc();
        
        // Read Back
        tempBuf[0] = 0;
        IAP_Eeprom_Read(1, (uint8_t *)&tempBuf, 15);
        pc.printf("EEprom Read : %s\r\n", &tempBuf[0]);
        
        i++;
    }
}
