/**
 * USB to UART Bridge
 */
 
#include "mbed.h"
#include "USBSerial.h"

// Serial TX Pin19, Serial RX Pin20
// Using port and pin names as the mbed definitions pin defs for the M0 are incorrect
Serial uart(P1_13, P1_14);
USBSerial pc;

// Called by ISR
void settingsChanged(int baud, int bits, int parity, int stop)
{
    const Serial::Parity parityTable[] = {Serial::None, Serial::Odd, Serial::Even, Serial::Forced0, Serial::Forced1};
    
    if (stop != 2) {
        stop = 1;   // stop bit(s) = 1 or 1.5
    }
    
    uart.baud(baud);
    uart.format(bits, parityTable[parity], stop);
}

int main()
{
    pc.attach(settingsChanged);
    
    while (1) {
        while (uart.readable()) {
           pc.putc(uart.getc());
        }
        
        while (pc.readable()) {
            uart.putc(pc.getc());
        }
    }
}
