#include "mbed.h"

DigitalIn Button(P0_1);
InterruptIn ButtonIrq(P0_1); 

DigitalOut Led2(P1_22);

void sleep_normal ( void )
{
    // PCON[PD] set to sleep
    LPC_PMU->PCON = 0x0;
    
    // SRC[SLEEPDEEP] set to 0 = sleep
    SCB->SCR &= ~SCB_SCR_SLEEPDEEP_Msk;
    
    // wait for interrupt
    __WFI();
}

// Section 3.9.4 of the LPC11U24 User Manual
void sleep_deep ( void )
{
// PCON[PD] set to deepsleep
    LPC_PMU->PCON = 0x1;
    
    // SRC[SLEEPDEEP] set to 1 = deep sleep
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
    
    // Power up everything after powerdown
    LPC_SYSCON->PDAWAKECFG &= 0xFFFFF800;
    
    // wait for interrupt
    __WFI();
}

void ButtonPressed ( void )
{
    // Wake up ..
    Led2 = !Led2;
}

int main() 
{
    Led2 = 1;
    Button.mode(PullUp);
    ButtonIrq.fall(ButtonPressed);
    
    while(1) 
    {
        // All I do is sleep
        //sleep_normal();
        sleep_deep();
    }
}
