#include "mbed.h"
#include "rtos.h"
#include "EPOS.h"

 
RawSerial pc(SERIAL_TX,SERIAL_RX);
CAN can(PB_5,PB_6);
EPOS epos1;
EPOS epos2;
EPOS epos3;
EPOS epos4;
EPOS epos5;
Thread thread1;
Thread thread2;
Thread thread3;
Thread thread4;
Thread thread5;
float quadc1;
float quadc2;
float quadc3;
float quadc4;


int main() {
    pc.baud(921600);
    can.frequency(250000);
    pc.printf("startup: \r\n");
    
    
    
    epos1.Setup_EPOS(1);
    epos2.Setup_EPOS(2);
    epos3.Setup_EPOS(3);
    epos4.Setup_EPOS(4);
    epos5.Setup_EPOS(5);
    
    epos1.Start_pos_mode();Thread::wait(10);
    epos2.Start_pos_mode();Thread::wait(10);
    epos3.Start_pos_mode();Thread::wait(10);
    epos4.Start_pos_mode();Thread::wait(10);
    epos5.Start_pos_mode();Thread::wait(10);
    
    thread1.start(&epos1,&EPOS::Homing);
    Thread::wait(5);
    thread2.start(&epos2,&EPOS::Homing);
    Thread::wait(5);
    thread3.start(&epos3,&EPOS::Homing);
    Thread::wait(5);
    thread4.start(&epos4,&EPOS::Homing);
    Thread::wait(5);
    thread5.start(&epos5,&EPOS::Homing);

    Thread::wait(11000);
    
    epos1.Start_pos_mode();Thread::wait(10);
    epos2.Start_pos_mode();Thread::wait(10);
    epos3.Start_pos_mode();Thread::wait(10);
    epos4.Start_pos_mode();Thread::wait(10);
    epos5.Start_pos_mode();Thread::wait(10);
    
    pc.printf("epos probably homed \r\n");
    
    // epos1 vleugel BB
    // epos2en3 vleugel midden
    // epos4 vleugel SB
    
    float AoA1_offset = 0.0f;
    float AoA2_offset = 0.0f;
    float AoA3_offset = 0.0f;
    float AoA4_offset = 0.0f;
    
    //-------------------------------------------------------------------------
    pc.printf("going to first position \r\n");
    
    
    float AoA1 = -3.0f; // AoA BB (deg)
    float AoA2 = 0.0f; // AoA mid (deg)
    float AoA3 = -3.0f; // AoA SB
    float AoA4 = 11.0f; // AoA rear
    
    quadc1 = (int)(13274*(AoA1  +AoA1_offset));      // Determine the quadcounts for EPOS
    quadc2 = (int)(-56757*(AoA2 +AoA2_offset));      // 1 degree of AoA approximates 
    quadc3 = (int)(13274*(AoA3  +AoA3_offset));      // 52113 quadcounts
    quadc4 = (int)(70796*(AoA4  +AoA4_offset));      // 52113 quadcounts
    
    can.write(epos1.Goto_Pos(quadc1));                                 // send new position to the controllers
    Thread::wait(1);
    can.write(epos2.Goto_Pos(quadc2));
    Thread::wait(1);
    can.write(epos3.Goto_Pos(quadc2));
    Thread::wait(1);
    can.write(epos4.Goto_Pos(quadc3));
    Thread::wait(1);
    can.write(epos5.Goto_Pos(quadc4));
    Thread::wait(1);
    
    Thread::wait(10000);
    
    //-------------------------------------------------------------------------
    pc.printf("going to second position \r\n");
    AoA1 = 0.0f; // AoA BB (deg)
    AoA2 = 2.5f; // AoA mid (deg)
    AoA3 = 0.0f; // AoA SB
    AoA4 = 11.0f; // AoA rear
    
    quadc1 = (int)(13274*(AoA1  +AoA1_offset));      // Determine the quadcounts for EPOS
    quadc2 = (int)(-56757*(AoA2 +AoA2_offset));      // 1 degree of AoA approximates 
    quadc3 = (int)(13274*(AoA3  +AoA3_offset));      // 52113 quadcounts
    quadc4 = (int)(70796*(AoA4  +AoA4_offset));      // 52113 quadcounts
    
    can.write(epos1.Goto_Pos(quadc1));                                 // send new position to the controllers
    Thread::wait(1);
    can.write(epos2.Goto_Pos(quadc2));
    Thread::wait(1);
    can.write(epos3.Goto_Pos(quadc2));
    Thread::wait(1);
    can.write(epos4.Goto_Pos(quadc3));
    Thread::wait(1);
    can.write(epos5.Goto_Pos(quadc4));
    Thread::wait(1);
    
    //-------------------------------------------------------------------------
    pc.printf("going to thrid position \r\n");
    AoA1 = 2.5f; // AoA BB (deg)
    AoA2 = 5.0f; // AoA mid (deg)
    AoA3 = 2.5f; // AoA SB
    AoA4 = 11.0f; // AoA rear
    
    quadc1 = (int)(13274*(AoA1  +AoA1_offset));      // Determine the quadcounts for EPOS
    quadc2 = (int)(-56757*(AoA2 +AoA2_offset));      // 1 degree of AoA approximates 
    quadc3 = (int)(13274*(AoA3  +AoA3_offset));      // 52113 quadcounts
    quadc4 = (int)(70796*(AoA4  +AoA4_offset));      // 52113 quadcounts
    
    can.write(epos1.Goto_Pos(quadc1));                                 // send new position to the controllers
    Thread::wait(1);
    can.write(epos2.Goto_Pos(quadc2));
    Thread::wait(1);
    can.write(epos3.Goto_Pos(quadc2));
    Thread::wait(1);
    can.write(epos4.Goto_Pos(quadc3));
    Thread::wait(1);
    can.write(epos5.Goto_Pos(quadc4));
    Thread::wait(1);
    
    //-------------------------------------------------------------------------
    pc.printf("going to fourth position \r\n");
    AoA1 = 5.0f; // AoA BB (deg)
    AoA2 = 10.0f; // AoA mid (deg)
    AoA3 = 5.0f; // AoA SB
    AoA4 = 11.0f; // AoA rear
    
    quadc1 = (int)(13274*(AoA1  +AoA1_offset));      // Determine the quadcounts for EPOS
    quadc2 = (int)(-56757*(AoA2 +AoA2_offset));      // 1 degree of AoA approximates 
    quadc3 = (int)(13274*(AoA3  +AoA3_offset));      // 52113 quadcounts
    quadc4 = (int)(70796*(AoA4  +AoA4_offset));      // 52113 quadcounts
    
    can.write(epos1.Goto_Pos(quadc1));                                 // send new position to the controllers
    Thread::wait(1);
    can.write(epos2.Goto_Pos(quadc2));
    Thread::wait(1);
    can.write(epos3.Goto_Pos(quadc2));
    Thread::wait(1);
    can.write(epos4.Goto_Pos(quadc3));
    Thread::wait(1);
    can.write(epos5.Goto_Pos(quadc4));
    Thread::wait(1);
}
