#include "mbed.h"
#include "rgb_led.h"

/*
-   number[] is the 3 digits. [0] is the digit for the letter L or H, and needs
    to be a 0 or a 1, for the display to light up.
-   number[1] is the 'tens', number [2] is the 'ones'.
-   The program takes care of the transistor count itself. So no need to
    send anything for that to the Ticker any longer. Now only the digits needs
    to be placed in number.
-   I got the ticker to work out here. Not in .h etc.
-   And I am fairly sure it says somewhere in the big white programming book
    that a enum starts from 1. However here it starts at 0. Så status needs to
    subtracted a 1, before it gets send to the function below. (RGB...).
*/    

DigitalOut Dig_1(PB_6);
DigitalOut Dig_2(PC_7);
DigitalOut Dig_3(PA_9);
DigitalOut Seg_A(PA_7); //original design says PA_3. I think there is a button
DigitalOut Seg_B(PA_10);//  here (PA_7).
DigitalOut Seg_C(PB_3);
DigitalOut Seg_D(PB_5);
DigitalOut Seg_E(PB_4);
DigitalOut Seg_F(PB_10);
DigitalOut Seg_G(PA_8);

int number[3] = {0, 0, 0};
int dig = 0;
int status;

void rgb_outp(int status);
void output();

Ticker output_ticker;

main()
{
    int i;
    output_ticker.attach(&output, 0.001);

    for(i = 0; i < 11; i++)             // Would need deletion from here..
    {
        if(i > 9)
        {
            i = 1;
        };
        
        number[0]++;
        if(number[0] > 9)
        {
            status = 0;
            rgb_outp(status);
            number[0] = 0;
            number[1]++;
            if(number[1] > 9)
            {
                status = 4;
                rgb_outp(status);
                number[1] = 0;
                number[2]++;
            }
        }
        if((number[0] == 9) && (number[1] == 9) && (number[2] == 9))
        {
            number[0] = 0;
            number[1] = 0;
            number[2] = 0;
        }
        
        
        wait(0.2);
    }                               // until here.
}

void output()
{
    int out_value;
    
    dig++;
    if(dig == 4)
    {
        dig = 1;
    }
    
    switch(dig)
    {
        case 1:
            Dig_1 = 0;
            Dig_2 = 0;
            Dig_3 = 1;
            out_value = number[0];
            break;
        case 2:
            Dig_1 = 0;
            Dig_2 = 1;
            Dig_3 = 0;
            out_value = number[1];
            break;
        case 3:
            Dig_1 = 1;
            Dig_2 = 0;
            Dig_3 = 0;
            if(number[2] == 0)
            {
                out_value = 20;
            }
            else if(number[2] == 1)
            {
                out_value = 30;
            }
            else
            {
                Dig_1 = 0;
                Dig_2 = 0;
                Dig_3 = 0;
            }
            break;
        default:
            Dig_1 = 0;
            Dig_2 = 0;
            Dig_3 = 0;
            out_value = 0;
    }
    
    switch(out_value)
    {
        case 0:
            Seg_A = 0;
            Seg_B = 0;
            Seg_C = 0;
            Seg_D = 0;
            Seg_E = 0;
            Seg_F = 0;
            Seg_G = 1;
            break;
        case 1:
            Seg_A = 1;
            Seg_B = 0;
            Seg_C = 0;
            Seg_D = 1;
            Seg_E = 1;
            Seg_F = 1;
            Seg_G = 1;
            break;
        case 2:
            Seg_A = 0;
            Seg_B = 0;
            Seg_C = 1;
            Seg_D = 0;
            Seg_E = 0;
            Seg_F = 1;
            Seg_G = 0;
            break;
        case 3:
            Seg_A = 0;
            Seg_B = 0;
            Seg_C = 0;
            Seg_D = 0;
            Seg_E = 1;
            Seg_F = 1;
            Seg_G = 0;
            break;
        case 4:
            Seg_A = 1;
            Seg_B = 0;
            Seg_C = 0;
            Seg_D = 1;
            Seg_E = 1;
            Seg_F = 0;
            Seg_G = 0;
            break;
        case 5:
            Seg_A = 0;
            Seg_B = 1;
            Seg_C = 0;
            Seg_D = 0;
            Seg_E = 1;
            Seg_F = 0;
            Seg_G = 0;
            break;
        case 6:
            Seg_A = 0;
            Seg_B = 1;
            Seg_C = 0;
            Seg_D = 0;
            Seg_E = 0;
            Seg_F = 0;
            Seg_G = 0;
            break;
        case 7:
            Seg_A = 0;
            Seg_B = 0;
            Seg_C = 0;
            Seg_D = 1;
            Seg_E = 1;
            Seg_F = 1;
            Seg_G = 1;
            break;
        case 8:
            Seg_A = 0;
            Seg_B = 0;
            Seg_C = 0;
            Seg_D = 0;
            Seg_E = 0;
            Seg_F = 0;
            Seg_G = 0;
            break;
        case 9:
            Seg_A = 0;
            Seg_B = 0;
            Seg_C = 0;
            Seg_D = 0;
            Seg_E = 1;
            Seg_F = 0;
            Seg_G = 0;
            break;
            case 20:
            Seg_A = 1;
            Seg_B = 1;
            Seg_C = 1;
            Seg_D = 0;
            Seg_E = 0;
            Seg_F = 0;
            Seg_G = 1;
            break;
        case 30:
            Seg_A = 1;
            Seg_B = 0;
            Seg_C = 0;
            Seg_D = 1;
            Seg_E = 0;
            Seg_F = 0;
            Seg_G = 0;
            break;
        default:
            Seg_A = 1;
            Seg_B = 1;
            Seg_C = 1;
            Seg_D = 1;
            Seg_E = 1;
            Seg_F = 1;
            Seg_G = 1;
    }   
}

void rgb_outp(int status)
{
    RGB_LED lamp(PB_13,PB_14, PB_15);   // Creates an object out of the class RGB_LED.
    // Connect pins on the Nucleo, to the pins the
    // class.

    enum colour     // Enumeration is used only for making the program more
    {               // easily readable.
        green,      // Is alike an int, starts at green = 1,
        orange,     // orange = 2 etc.
        red,
        red_blink,
        blue
    };

    colour RGB_out = static_cast<colour>(status);
    // Taking the value from the sensors and change them the enum type.
    // Enum is somewhat akin to an int already, but RGB_out != status..

    switch(RGB_out)
    {
        case green:
            lamp.set(0.0f, 0.0f, 1.0f);
            break;
        case orange:
            lamp.set(1.0f, 1.0f, 0.0f);
            break;
        case red:
            lamp.set(1.0f, 0.0f, 0.0f);
            break;
        case red_blink:
            lamp.flash(1.0f, 0.5f, 1.0f, 0.0f, 1.0f, 0.0f);         
            // On for 50% of every 1 seconds.
            break;
        case blue:
            lamp.flash(1.0f, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f);     
            // On for 50% of every 0.5 seconds.
            break;
        default:   // Error has occured, blue. Could just have defaulted instead
            lamp.set(1.0f, 1.0f, 1.0f);     // of case blue, however as it is an
    }

    return;
}