/*
-------------------------------------------------------------------------------
-- Project:         PRO2 "Awareness and Optimisation of energy consumption"
-- Team:            Team 1

-- File Name:       main.cpp
-- Authors:         Poul Erik Tjørnfelt, Olga Hoeyer,
--                  Emil Hammer, Heidi Svenningsen
-- Date:            07/05-2017
-- Copyright:       Open to all
-- Version:         1.0 - Creation of file
--                  1.2 - debugging
--                  2.1 - Modular structure added
--                  2.2 - Ticker added
--                  2.3 - Debugging
--
-- Description:     Program is amde as a semester projekt for Elektronical
--                  design education in Aarhus University.
--                  Program reads temperature and humidity from sensor SHT-15
--                  and based on the temperature limits gives a light signal
--                  to the user when air refreshment is needed.
--                  Need an input from the user for desirable temperature.
-------------------------------------------------------------------------------
*/


//Defining and Including libraries here
#include "mbed.h"
#include "SHTx/sht15.hpp"
#include <7_segment_control.h>
#include <compare.h>
#include <data_out.h>
#include <logging.h>
#include <Settings.h>
#include <rgb_led.h>
#include <Ticker.h>

//Declaration of GLOBAL VARIABLES:
float temperature, humidity;            //this will be data read from sensor
void GetTemperatureAndHumidity();       //via denne function



int temp_digit1=2;                                                              //DELETE LATER!
int temp_digit2=5;                                                              //DELETE LATER!

int status;

Serial pc(USBTX, USBRX);
InterruptIn event(USER_BUTTON);
DigitalOut myled(LED1);
DigitalIn up(PA_5);
DigitalIn down(PA_6);
SHTx::SHT15 sensor(PB_8, PB_9);         //ports on the Nucleo: PB_8, PB_9
RGB_outp(pin1, pin2, pin3);                                                     //ports MANGLER!!!!!!!
segment_7::segment_7(PinName seg_A, PinName seg_B, PinName seg_C, PinName seg_D,
                     PinName seg_E, PinName seg_F, PinName seg_G, PinName DP,
                     PinName dig_1, PinName dig_2, PinName dig_3)               //ports MANGLER!!!!!!!
//Knapper???                                                                    //ports MANGLER!!!!!!!


Ticker tick1;
Ticker tick2;
Ticker tick3;
Ticker tick4;

int main()
{
    int temperature_low=0;                                                         //DE!
    int temperature_high=0;                                                        //DELE
    //tick1.attach(&Settings(), 20);                   //Settings
    tick2.attach(&GetTemperatureAndHumidity(),6000);  //Data Collection 6000 ms = 1 (min)*60(sec)*100(ms)

    while(1) {
        Settings(&t_low, &tmp_high);         //skal returnere: temperature_low, temperature_high, temp_digit1, temp_digit2
        segment_7();
        segment_7::show(temp_digit1,3);
        segment_7::show(temp_digit2,3);
        
       // GetTemperatureAndHumidity();    //returnerer humidity; temperature
        status=Compare_values(humidity, temperature, temperature_low, temperature_high);
        rgb_outp(status);
        logging ();        
    }
}


void GetTemperatureAndHumidity() //can't move to the .h file, pga "sensor" definitions.
{

// Speed things up a bit.
    sensor.setOTPReload(false);
    sensor.setResolution(true);

    //busy = true;
    sensor.update();
    //busy = false;

    // Temperature in celcius
    sensor.setScale(false);
    temperature=sensor.getTemperature();

    // Relative Humidity
    humidity=sensor.getHumidity();

    wait(5);
    return;
}