/**
 * Program for reading temperature and humidity from SHT15
 * Modified to fit to EDE Pro2 Team 1 project.
 * Author Olga Høyer
 * Original Copyright (c) 2010 Roy van Dam <roy@negative-black.org>
**/

#include "mbed.h"                       //NOTE. Compiler gives an error:
#include "SHTx/sht15.hpp"               //"CMSIS Target not recognised"

//GLOBAL VARIABLES:
float temperature, humidity;            //this will be data read from sensor
void GetTemperatureAndHumidity();

Serial pc(USBTX, USBRX);
DigitalOut busy(LED1);                  //Don't think we need it.

//ports on the Nucleo: PB_8, PB_9
SHTx::SHT15 sensor(PB_8, PB_9);


int
main()
{
    GetTemperatureAndHumidity();
}

void GetTemperatureAndHumidity()
{
// Speed things up a bit.
sensor.setOTPReload(false);
sensor.setResolution(true);

while(1)
{
    busy = true;
    sensor.update();
    busy = false;

    // Temperature in celcius
    sensor.setScale(false);
    temperature=sensor.getTemperature();        //don't know if it works

    // Relative Humidity
    humidity=sensor.getHumidity();               //don't know if it works

    wait(5);
    return;
}
}