#ifndef _Sensor_h
#define _Sensor_h

#include "mbed.h"

#define DEFAULT_DEVICE_ADDRESS               0x29

#define FAILURE_RESET  -1

#define IDENTIFICATION_MODEL_ID              0x0000
#define IDENTIFICATION_MODEL_REV_MAJOR       0x0001
#define IDENTIFICATION_MODEL_REV_MINOR       0x0002
#define IDENTIFICATION_MODULE_REV_MAJOR      0x0003
#define IDENTIFICATION_MODULE_REV_MINOR      0x0004
#define IDENTIFICATION_DATE                  0x0006 //16bit value
#define IDENTIFICATION_TIME                  0x0008 //16bit value

#define SYSTEM_MODE_GPIO0                    0x0010
#define SYSTEM_MODE_GPIO1                    0x0011
#define SYSTEM_HISTORY_CTRL                  0x0012
#define SYSTEM_INTERRUPT_CONFIG_GPIO         0x0014
#define SYSTEM_INTERRUPT_CLEAR               0x0015
#define SYSTEM_FRESH_OUT_OF_RESET            0x0016
#define SYSTEM_GROUPED_PARAMETER_HOLD        0x0017

#define SYSRANGE_START                       0x0018
#define SYSRANGE_THRESH_HIGH                 0x0019
#define SYSRANGE_THRESH_LOW                  0x001A
#define SYSRANGE_INTERMEASUREMENT_PERIOD     0x001B
#define SYSRANGE_MAX_CONVERGENCE_TIME        0x001C
#define SYSRANGE_CROSSTALK_COMPENSATION_RATE 0x001E
#define SYSRANGE_CROSSTALK_VALID_HEIGHT      0x0021
#define SYSRANGE_EARLY_CONVERGENCE_ESTIMATE  0x0022
#define SYSRANGE_PART_TO_PART_RANGE_OFFSET   0x0024
#define SYSRANGE_RANGE_IGNORE_VALID_HEIGHT   0x0025
#define SYSRANGE_RANGE_IGNORE_THRESHOLD      0x0026
#define SYSRANGE_MAX_AMBIENT_LEVEL_MULT      0x002C
#define SYSRANGE_RANGE_CHECK_ENABLES         0x002D
#define SYSRANGE_VHV_RECALIBRATE             0x002E
#define SYSRANGE_VHV_REPEAT_RATE             0x0031

#define SYSALS_START                         0x0038
#define SYSALS_THRESH_HIGH                   0x003A
#define SYSALS_THRESH_LOW                    0x003C
#define SYSALS_INTERMEASUREMENT_PERIOD       0x003E
#define SYSALS_ANALOGUE_GAIN                 0x003F
#define SYSALS_INTEGRATION_PERIOD            0x0040

#define RESULT_RANGE_STATUS                  0x004D
#define RESULT_ALS_STATUS                    0x004E
#define RESULT_INTERRUPT_STATUS_GPIO         0x004F
#define RESULT_ALS_VAL                       0x0050
#define RESULT_HISTORY_BUFFER                0x0052 
#define RESULT_RANGE_VAL                     0x0062
#define RESULT_RANGE_RAW                     0x0064
#define RESULT_RANGE_RETURN_RATE             0x0066
#define RESULT_RANGE_REFERENCE_RATE          0x0068
#define RESULT_RANGE_RETURN_SIGNAL_COUNT     0x006C
#define RESULT_RANGE_REFERENCE_SIGNAL_COUNT  0x0070
#define RESULT_RANGE_RETURN_AMB_COUNT        0x0074
#define RESULT_RANGE_REFERENCE_AMB_COUNT     0x0078
#define RESULT_RANGE_RETURN_CONV_TIME        0x007C
#define RESULT_RANGE_REFERENCE_CONV_TIME     0x0080

#define READOUT_AVERAGING_SAMPLE_PERIOD      0x010A
#define FIRMWARE_BOOTUP                      0x0119
#define FIRMWARE_RESULT_SCALER               0x0120
#define I2C_SLAVE_DEVICE_ADDRESS             0x0212
#define INTERLEAVED_MODE_ENABLE              0x02A3

class Sensor{
    
public:
    /** Constructor
    * Create a VL6180 object at I2C specified address (7 bit).
    * 
    * @param sda I2C sda pin number
    * @param scl I2C scl pin number
    * @param shdn I2C shdn pin number
    */
    Sensor(PinName sda, PinName scl, PinName shdn);
    
    /** Init the sensor, load settings and change I2C address
    *
    * @param address I2C new address
    */
    int init();
    
    /** Change I2C address
    * 
    */
    void changeAddress(char address);
    
    /** Make a range reading
    *
    */
    float read();
    
    /** Turn off the device
    *   
    */
    void turnOff();
    
    /** Turn on the device
    * 
    */
    void turnOn();
    
    /** Indicate if the device detects an obstacle
    *
    *   @return true if osbtacle otherwise false
    */
    bool getIsObstacle();
        
private:
    char addr;
    I2C i2c;
    DigitalOut SHDN;
    bool isObstacle;
    void startRange();
    void pollRange();
    float readRange();
    void clearInterrupts();
    void setRegister(wchar_t reg, char data);
    void writeByte(wchar_t reg,char data);
    char readByte(wchar_t reg);
    
};
#endif