#include "mbed.h"
#include "BufferedSerial.h"  // solves issues of loosing data. alternative doing it yourself
//------------------------------------
// Hyperterminal configuration
// 57600 bauds, 8-bit data, no parity
//------------------------------------
// Incoming Message parser  Format: "$<CMD>,<Value>\r\n" // up to /r/n

BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial BLE(D1, D0);
DigitalOut myled(LED1);

#define DEBUG_MSG

// Incoming Message parser
void Parse_Message(char inbyte);
// Apply command
void Apply_Command(int command, float value);

int main()
{
    pc.baud(57600);
    BLE.baud(57600);
    pc.printf("Hello Plant!\r\n");
    BLE.printf("Hello Plant !\r\n");
    while(1) {
        //wait(1);
        //pc.printf("This program runs since %d seconds.\r\n", i++);
        //BLE.printf("This program runs since %d seconds.\r\n", i++);

        while(BLE.readable()) {
            uint8_t in_byte = BLE.getc();
            //pc.putc(in_byte);
            Parse_Message(in_byte);
            
        }
        while(pc.readable()) {
            uint8_t in_byte = pc.getc();
            //BLE.putc(in_byte);
            Parse_Message(in_byte);
            
        }              
        myled = !myled;
    }
}

// Incoming Message parser  Format: "$<CMD>,<Value>\r\n" // up to /r/n
void Parse_Message(char inbyte)
{
    static const uint16_t BufferCMDSize=32;
    static const uint16_t BufferCMD_ValuesSize=2;

    static float CMD_Values[BufferCMD_ValuesSize]= {0};
    static char BufferCMD[BufferCMDSize]= {0};
    static uint16_t BufferIndex=0;
    static uint16_t Values_Index=0;

    BufferIndex=BufferIndex%(BufferCMDSize); // simple overflow handler
    Values_Index=Values_Index%(BufferCMD_ValuesSize); // simple overflow handler

    BufferCMD[BufferIndex]=inbyte;
    BufferIndex++;

    // parse incoming message
    if (inbyte=='$') { // start of message
        BufferIndex=0; // initialize to start of parser
        Values_Index=0; // index for values position
    } else if (inbyte==',') { // seperator char
        CMD_Values[Values_Index]=atof(BufferCMD); // input value to buffer values
        BufferIndex=0; // initialize to start of parser
        Values_Index++;
        if (Values_Index >= (BufferCMD_ValuesSize-1)) Values_Index=(BufferCMD_ValuesSize-1); // buffer overflow
    } else if(inbyte=='\r') { // end of message // parse message
        // Update last value
        CMD_Values[Values_Index]=atof(BufferCMD); // input value to buffer values

        BufferIndex=0; // initialize to start of parser
        Values_Index=0; // reset values index

        //////////////////////
        // Command recievd: //
        //////////////////////
        int command = (int)CMD_Values[0];
        float value = CMD_Values[1];

#ifdef DEBUG_MSG
        pc.printf("CMD: %d ,%.3f \r\n" ,command,value); // debug check
#endif /* DEBUG_MSG */

        // apply commands
        Apply_Command(command,value);

    }//end parser
}// end parser function


void Apply_Command(int command, float value)
{
    bool state = 0; // boolean cast for value
    switch (command) {
        case 0 : //
            break;
        case 1 : //
            break;
        case 2 : //
            break;
        case 3 : // 
            break;
        case 4 : // 
            break;
        case 5 : // 
            break;
        case 6 : // 
            break;
        case 7 : // 
            break;
        case 8 : // Data Stream
            break;
        default :
            printf("Invalid Command\r\n" );
    }// end switch
}// end apply command