//* ********************************************** */
/* main_J.cpp
/* Projector autostart project
/* Nam Nguyen
/* Oksana Tovstolytkina
/* May 2017
/* ********************************************** */

#include <mbed.h>

#include "ReceiverIR.h"
#include "TransmitterIR.h"

#define SIMPLE_TEST 1
AnalogIn usb(PA_7);// recevoir le feedback du projecteur
ReceiverIR ir_rx( D8 );
TransmitterIR ir_tx( D9 );
Ticker ledTicker;

Serial pc(USBTX,USBRX);
/**
 * Receive.
 *
 * @param format Pointer to a format.
 * @param buf Pointer to a buffer.
 * @param bufsiz Size of the buffer.
 *
 * @return Bit length of the received data.
 */
int receive(RemoteIR::Format *format, uint8_t *buf, int bufsiz, int timeout = 100)
{
    int cnt = 0;
    while (ir_rx.getState() != ReceiverIR::Received) {
        cnt++;
        if (timeout < cnt) {
            return -1;
        }
    }
    return ir_rx.getData(format, buf, bufsiz * 8);
}

/**
 * Transmit.
 *
 * @param format Format.
 * @param buf Pointer to a buffer.
 * @param bitlength Bit length of the data.
 *
 * @return Bit length of the received data.
 */
int transmit(RemoteIR::Format format, uint8_t *buf, int bitlength, int timeout = 100)//buffer est un espace de stockage que je peux trasmettre ou recevoir
{
    int cnt = 0;
    while (ir_tx.getState() != TransmitterIR::Idle) { //IDLE pour dire que mon transmetteur est pret à envoyer
        cnt++;
        if (timeout < cnt) {
            return -1;
        }
    }
    return ir_tx.setData(format, buf, bitlength);
}

void executeCommand(char* _command)
{
    if (strcmp(_command, "projectorOff") == 0) {
        float value=0.0f;
        value=usb.read();
        if(value >= 1) {
            uint8_t test_buflength1 = 32;
            RemoteIR::Format testformat = RemoteIR::NEC;

            uint8_t power_buf[32]= {  0x04,    0x0F,   0xAD,   0x52,
                                      0x00, 0x00, 0x00, 0x00,
                                      0x00, 0x00, 0x00, 0x00,
                                      0x00, 0x00, 0x00, 0x00,
                                   };


            test_buflength1 = transmit(testformat, power_buf, test_buflength1);
            pc.printf("Ok\n");
        } else {
            pc.printf("Already Off\n");
        }
        return;
    }
    if (strcmp(_command, "projectorOn") == 0) {
        float value=0.0f;
        value=usb.read();
        if(value<1) {
            uint8_t power_buf[32]= {  0x04,    0x0F,   0xAD,   0x52,
                                      0x00, 0x00, 0x00, 0x00,
                                      0x00, 0x00, 0x00, 0x00,
                                      0x00, 0x00, 0x00, 0x00,
                                   };
            uint8_t test_buflength1 = 32;
            RemoteIR::Format testformat = RemoteIR::NEC;
            test_buflength1 = transmit(testformat, power_buf, test_buflength1);
            pc.printf("Ok\n");
        } else {
            pc.printf("Already On\n");
        }
        return;
    }
    return;
}

void getQueryResponse(char* _query)
{
    if (strcmp(_query, "projectorStatus") == 0) {
        float value = 0.0f;
        value=usb.read();
        if (value<1) {
            pc.printf("Off\n");
        } else {
            pc.printf("On\n");
        }
        return;
    }
    if (strcmp(_query, "version") == 0)   {
        pc.printf("1.0\n");
        return;
    }
}

/**
 * Entry point.
 */
int main(void)
{
    unsigned int bufferCounter=0;
    char buffer[1024];

    char* queryStart = "<query>";
    char* queryEnd = "</query>";
    char* commandStart = "<command>";
    char* commandEnd = "</command>";

    pc.baud(115200);

    while(1) {
        if (pc.readable()) {
            char currentChar = pc.getc(); // lire la currentSymbole par le STM envoyé par PC
            if (currentChar == '\n' || currentChar == '\r') {
                buffer[bufferCounter + 1] = 0;

                if (strncmp(buffer, queryStart, strlen(queryStart)) == 0) {
                    char* queryEndPos = strstr(buffer, queryEnd);
                    *queryEndPos = '\0';
                    getQueryResponse(buffer + strlen(queryStart));
                    memset(&buffer[0], 0, 1024);
                    bufferCounter = 0;
                }

                if (strncmp(buffer, commandStart, strlen(commandStart)) == 0) {
                    char* commandEndPos = strstr(buffer, commandEnd);
                    *commandEndPos = '\0';
                    executeCommand(buffer + strlen(commandStart));
                    memset(&buffer[0], 0, 1024);
                    bufferCounter = 0;
                }
            } else {
                buffer[bufferCounter] = currentChar;
                bufferCounter++;
                if (bufferCounter > 1024) {
                    memset(&buffer[0], 0, 1024);
                    bufferCounter = 0;
                }
                printf("%c", currentChar);
            }
        }
    }
}