#include "mbed.h"
#include "time.h"       

DigitalOut myled(LED1);
//serial connection via USB
Serial pc(USBTX, USBRX); 
AnalogIn pH_sensor(A0);
AnalogIn temp_sensor(A1);
 

int main()
{
    pc.baud(115200);
    float voltage, pH, tempC, tempF;
    //Power temperature sensor  
    while(1) {
        //Take average of readings over 10 seconds
        double totalVal = 0.0;
        double pH_sensor_read = 0.0;
        double totalValtemp = 0.0;
        double temp_sensor_read = 0.0;
        int totalReadings = 0;
        time_t start = time(NULL);
        time_t seconds = 5;
        time_t end = start + seconds;
        while(time(NULL) < end){
            pH_sensor_read = pH_sensor.read();
            totalVal = totalVal + pH_sensor_read;
            temp_sensor_read = temp_sensor.read();
            totalValtemp = totalValtemp + temp_sensor_read;
            totalReadings++;
            
            }
            double avgSensor = totalVal/(double)totalReadings;
            double avgTemp = totalValtemp/(totalReadings);
        //Hard coded calibration values taken at pH 4 solution to return voltage in mV
        //.24 is the pin read out at pH4
        //800 is mV at ph4
        //look at the documentation to figure out what readout correlates to what voltage
        voltage = avgSensor*(3.3);
        //conversion to pH from sensor output voltage per LM61 data sheet
        pH = (voltage-.60924)/.05226667;
        //conversion to degrees C from sensor output voltage
        float voltageT = avgTemp*3.3*1000;
        //following equation is based off of a very rough calculation
        tempC = ((voltageT - 616.4)/-1.93);
        
        tempF = (tempC *9/5) + 32;
        //print current pH and temp
        pc.printf("pH = %5.2F at voltage %5.2F V\n\r", pH, voltage);
        pc.printf("temp = %5.2F F at voltage %5.2F V\n\r", tempF, voltageT);            
    }
}