#include "mbed.h"
#include "time.h"       

DigitalOut myled(LED1);
//serial connection via USB
Serial pc(USBTX, USBRX); 
AnalogIn pH_sensor(A0);
AnalogOut temp_sensor(A2);
 

int main()
{
    float voltage, pH, tempC, tempF;
    //Power temperature sensor  
    temp_sensor = 0.00002;
    while(1) {
        //Take average of readings over 10 seconds
        double totalVal = 0.0;
        double pH_sensor_read = 0.0;
        int totalReadings = 0;
        time_t start = time(NULL);
        time_t seconds = 10;
        time_t end = start + seconds;
        while(time(NULL) < end){
            pH_sensor_read = pH_sensor.read();
            totalVal = totalVal + pH_sensor_read;
            totalReadings++;
            }
            double avgSensor = totalVal/(double)totalReadings;
        //Hard coded calibration values taken at pH 4 solution to return voltage in mV
        voltage = avgSensor*(800/.24);
        //conversion to pH from sensor output voltage per LM61 data sheet
        pH = (0.0209*voltage)-12.696;
        //conversion to degrees C from sensor output voltage
        tempC = (((voltage/1000) - 0.871481)/-0.0021504);
        tempF = (tempC *9/5) + 32;
        //print current pH and temp
        pc.printf("pH = %5.2F & temp = %5.2F F\n\r", pH, tempF);            
    }
}