#include "mbed.h"
#include "BLEPeripheral.h"

//serial connection via USB 
Serial serial(USBTX, USBRX);

//Declare Input and Output pins
DigitalIn pb(D3);
AnalogIn pH_sensor(A0);
InterruptIn button(D2); 
DigitalOut led(LED_RED);
AnalogIn temp_sensor(A1);

// The SPI construct, REQN and RDYN IO construct should be modified manually
// It depend on the board you are using and the REQN&RDYN configuration on BLE Shield
SPI spi(PTD2, PTD3, PTD1);      
DigitalInOut BLE_RDY(PTD5);  
DigitalInOut BLE_REQ(PTD0); 
DigitalInOut BLE_RESET(PTA13);

//for BLE
int count = 0;
unsigned char tempbuf[2] = {0};
unsigned char templen = 0;
unsigned char decbuf[2] = {0};
unsigned char declen = 0;
unsigned char pHbuf[2] = {0};
unsigned char pHlen = 0;

/*----- BLE Utility -------------------------------------------------------------------------*/
// create peripheral instance, see pinouts above
BLEPeripheral            blePeripheral        = BLEPeripheral(&BLE_REQ, &BLE_RDY, NULL);
 
// create service
BLEService               uartService          = BLEService("713d0000503e4c75ba943148f18d941e");
 
// create characteristic
BLECharacteristic    txCharacteristic = BLECharacteristic("713d0002503e4c75ba943148f18d941e", BLENotify, 20, 0);
BLECharacteristic    rxCharacteristic = BLECharacteristic("713d0003503e4c75ba943148f18d941e", BLENotify, 20, 1);
/*--------------------------------------------------------------------------------------------*/
unsigned int interval = 0;
unsigned char count_on = 0;

//for pH measurement
float calib = 0;
float calib2 = 0;
float avgReading = 0;
float avgTempReading = 0;
bool calibrationORnot = true;
bool ready = false;
//int* reading[] = {0,0};


//This loop takes a reading by taking 15 measurements and averaging them when it is called in the loop "measure"
float takepHReading()
{
    float totalVal = 0.0;
    float pH_sensor_read = 0.0;
    int totalReadings = 0;
    while(totalReadings < 16){
        pH_sensor_read = pH_sensor.read();
        totalVal = totalVal + pH_sensor_read;
        totalReadings++;
        }
    float avgSensor = totalVal/totalReadings;      
    return avgSensor;
 }
 
 float takeTempReading()
{
    float totalTempVal = 0.0;
    float temp_sensor_read = 0.0;
    int totalReadings2 = 0;
    while(totalReadings2 < 30){
        temp_sensor_read = temp_sensor.read();
        totalTempVal = totalTempVal + temp_sensor_read;
        totalReadings2++;
        }
    float avgTempSensor = totalTempVal/totalReadings2;      
    return avgTempSensor;
 }

void calibration()
{
//serial.printf("enter calibration loop\n");
    //Loop to take calibration value
    calib = takepHReading();
    calib2 = takeTempReading();
    //serial.printf("calib is %d\n", calib);
}

void calculate()
{
    //serial.printf("entered calc\n");
    //Take average of readings over 10 seconds        
    avgReading = takepHReading();
    avgTempReading = takeTempReading();
    //serial.printf("took reading\n");
    ready = true;
}

void measure()
{
    serial.baud(115200);
    //serial.printf("start measurement");
    //cb.mode(PullUp);
    if(calibrationORnot)
    {
        calibration();
        calibrationORnot = !calibrationORnot;
    }    
//Loop to take measurement        
    else if(!calibrationORnot) 
    {
    //  serial.printf("enter measurement loop\n");
     //   serial.printf("calib is %d\n", calib);
        calculate();
    }
}


int main()
{ 
    pb.mode(PullUp);
    serial.baud(115200);
    serial.printf("Hello SmartD!\n");
    serial.printf("Serial begin!\r\n");
    float pH,yint,tempC,tempF;

     /*----- BLE Utility ---------------------------------------------*/
    // set advertised local name and service UUID
    blePeripheral.setLocalName("Sita");
    
    blePeripheral.setAdvertisedServiceUuid(uartService.uuid());
        
    // add service and characteristic
    blePeripheral.addAttribute(uartService);
    blePeripheral.addAttribute(rxCharacteristic);
    blePeripheral.addAttribute(txCharacteristic);

    // begin initialization
    blePeripheral.begin();
    /*---------------------------------------------------------------*/

    //serial.printf("GOT IT pH is %d, Temp is %d\n\r", reading[0], reading[1]);    
    serial.printf("\nBLE UART Peripheral begin!\r\n");
    if (calibrationORnot)
    {    
        button.rise(&measure);
    }
    
    while(1)
    {
        BLECentral central = blePeripheral.central();
        if (ready) 
        {
            //calcuating yintercept of the ADC -> pH equation using calibration value and given that calibration liquid is pH4
            yint = (68.97*calib)-4;
            //serial.printf("yint is %f", yint);
            //assumes linear relationship between pin readout -> voltage ->pH
            pH = (0.0209*3300)*(avgReading)-yint;
            serial.printf("avgreading = %f & yint = %f F & calib = %f\n\r", avgReading, yint, calib);

            serial.printf("pH = %f\n\r", pH);
            //conversion to degrees C from sensor output voltage
            tempC = (((3000*avgTempReading/1000) - 1.022129)/-0.0018496);
            tempF = (tempC *9/5) + 32;
            //print current pH and temp
            serial.printf("pH = %f & temp = %f F\n\r", pH, tempF);
            ready = !ready;
        }
        
        if (central) 
        {
            // central connected to peripheral
            serial.printf("Connected to central\r\n");
            while (central.connected()) 
            {
                if(!pb)
                {
                    tempF = 98.5;
                    int tempint = tempF;
                    int tempdecimal = (tempF-tempint)*100;
                    int pHint = pH;
                    int pHdecimal = (pH-pHint)*100;                    
                    serial.printf("pH = %d, pHdec = %d\n\r", pHint,pHdecimal);
//                    int tempint = 20;
//                    int tempdecimal = 23;
//                    int pHint = 9;
                    tempbuf[0]= tempint;
                    tempbuf[1] = tempdecimal;
                    //tempbuf[templen] = tempint;
                    //decbuf[declen] = decimal;
                    pHbuf[0] = pHint;
                    pHbuf[1] = pHdecimal;
                    interval++;
                }

                if(interval == 1) 
                { // If there is no char available last the interval, send the received chars to central.
                    //serial.printf("Received from terminal: %d bytes\r\n", templen);
                    txCharacteristic.setValue((const unsigned char *)tempbuf, 2);
                    txCharacteristic.setValue((const unsigned char *)pHbuf, 2);
                    serial.printf("done");
                    wait(2);
                    interval = 0;
                }
            }
            // central disconnected
            serial.printf("Disconnected from central\r\n");
        }
    }
}