#include "mbed.h"
#include "BLEPeripheral.h"

//serial connection via USB 
Serial serial(USBTX, USBRX);

//Declare Input and Output pins
DigitalIn pb(D3);
AnalogIn pH_sensor(A0);
DigitalIn cb(D2); 
DigitalOut led(LED_RED);

// The SPI construct, REQN and RDYN IO construct should be modified manually
// It depend on the board you are using and the REQN&RDYN configuration on BLE Shield
SPI spi(PTD2, PTD3, PTD1);      
DigitalInOut BLE_RDY(PTD5);  
DigitalInOut BLE_REQ(PTD0); 
DigitalInOut BLE_RESET(PTA13);

//for BLE
int count = 0;
unsigned char txbuf[16] = {0};
unsigned char txlen = 0;

//for pH measurement
float calib = 0;
float avgReading = 0;

//This loop takes a reading by taking 15 measurements and averaging them when it is called in the loop "measure"
int takeReading()
{
    double totalVal = 0.0;
    double pH_sensor_read = 0.0;
    int totalReadings = 0;
    while(totalReadings < 16){
        pH_sensor_read = pH_sensor.read();
        totalVal = totalVal + pH_sensor_read;
        totalReadings++;
        }
    float avgSensor = totalVal/15;      
    if (avgSensor > 0.3)
    {
        led = 1;
    }
    return avgSensor;
 }

int* measure()
{
    serial.baud(115200);
    serial.printf("start");
    float voltage, pH, tempC, tempF,loopnumber,yint;
    cb.mode(PullUp);
    led = 0;
    loopnumber = 1;
    
//Loop to run calibration value 
    while(loopnumber==1) 
    {
          if(!cb)
          {
                serial.printf("calib is %f\n", calib);
                calib = takeReading();
                serial.printf("calib is %d\n", calib);
                loopnumber = 2;
          }
    }
        
//Loop to take measurement        
    while(loopnumber==2) 
    {
        serial.printf("enter new loop\n");
        serial.printf("calib is %d\n", calib);
        //Take average of readings over 10 seconds
        avgReading = takeReading();
        //Hard coded calibration values taken at pH 4 solution to return voltage in mV
        //.24 is the pin read out at pH4
        //800 is mV at ph4
        //voltage = avgReading*(800/.24);  
        
        //trying to get voltage straight from MicroController -- this command does not work
        //voltage = ADC_GetConversionValue(pH_sensor);
        
        //conversion to pH from sensor output voltage per LM61 data sheet
        //pH = (0.0209*voltage)-12.696;
        
        //calcuating yintercept of the ADC -> pH equation using calibration value and given that calibration liquid is pH4
        yint = (68.97*calib)-4;
        serial.printf("yint is %f", yint);
        //assumes linear relationship between pin readout -> voltage ->pH
        pH = (0.0209*3300)*(avgReading)-yint;
        //conversion to degrees C from sensor output voltage
        tempC = (((voltage/1000) - 1.022129)/-0.0018496);
        tempF = (tempC *9/5) + 32;
        //print current pH and temp
        serial.printf("pH = %5.2F & temp = %5.2F F\n\r", pH, tempF);           
    }
    int pHtemparray[] = {pH,tempF};
    return pHtemparray;
}


/*----- BLE Utility -------------------------------------------------------------------------*/
// create peripheral instance, see pinouts above
BLEPeripheral            blePeripheral        = BLEPeripheral(&BLE_REQ, &BLE_RDY, NULL);
 
// create service
BLEService               uartService          = BLEService("713d0000503e4c75ba943148f18d941e");
 
// create characteristic
BLECharacteristic    txCharacteristic = BLECharacteristic("713d0002503e4c75ba943148f18d941e", BLENotify, 20);
BLECharacteristic    rxCharacteristic = BLECharacteristic("713d0003503e4c75ba943148f18d941e", BLEWriteWithoutResponse, 20);
/*--------------------------------------------------------------------------------------------*/
 
unsigned int interval = 0;
unsigned char count_on = 0;
 
int main()
{ 
    
    pb.mode(PullUp);
    serial.baud(115200);
    serial.printf("Hello SmartD!\n");
    serial.printf("Serial begin!\r\n");
    void begin();
 
     /*----- BLE Utility ---------------------------------------------*/
    // set advertised local name and service UUID
    blePeripheral.setLocalName("Sita");
    
    blePeripheral.setAdvertisedServiceUuid(uartService.uuid());
        
    // add service and characteristic
    blePeripheral.addAttribute(uartService);
    blePeripheral.addAttribute(rxCharacteristic);
    blePeripheral.addAttribute(txCharacteristic);

    // begin initialization
    blePeripheral.begin();
    /*---------------------------------------------------------------*/
    
    serial.printf("BLE UART Peripheral begin!\r\n");
    int* reading = measure();
    serial.printf("pH is %d, Temp is %d\n\r", reading[0], reading[1]);
    while(1)
    {
        BLECentral central = blePeripheral.central();
        if (central) 
        {
            // central connected to peripheral
            serial.printf("Connected to central\r\n");
            while (central.connected()) 
            {
                if (!pb)  // if button pushed
                {
                    // Read and send out pH value from measure function
                    unsigned short value = reading[0];
                    const unsigned char val[1] = {value};
                    txCharacteristic.setValue(val,1);
                }
            }
        
            // central disconnected
            serial.printf("Disconnected from central\r\n");
        }
    }
}