#include "mbed.h"
#include "SerialBase.h"
#include "Watchdog.h"

Serial pc(USBTX,USBRX);
Serial rf(D1, NC, 4800);
DigitalOut myled(LED1);
AnalogIn   ain(A0);
Ticker led_rf_ticker;
Ticker adc_ticker;
Timer t;

int adc_data[1024];
int adc_data_counter = 0;
int current_threshold = 3000;
int time_threshold = 30;
bool data_ready = false;
bool rf_32Asafe = false;

Watchdog wd;

void led_rf_blinky (void)
{
    myled = !myled;
    if(rf_32Asafe == true)
    {
        rf.printf("HHHHHHHH");
        pc.printf("Transmit: Charge at 32A\r\n");
        
    }
    else
    {
        rf.printf("LLLLLLLL");
        pc.printf("Transmit: Charge at 16A\r\n");
    }
}

void read_adc (void)
{
    if (adc_data_counter < 1024)
    {
        adc_data[adc_data_counter] = ain.read_u16();
        adc_data_counter+=1;
    }
    else
    {
        data_ready = true;
    }
}    
   
int main() 
{
    if (wd.WatchdogCausedReset()) pc.printf("Watchdog caused reset\r\n");
    wd.Configure(5.0); 
    float sum;
    int i;
    led_rf_ticker.attach(&led_rf_blinky, 0.2);
    adc_ticker.attach_us(&read_adc, 2000);
    t.reset();
    
    while(1) 
    {
        wd.Service();
        if (data_ready == true)
        {   
            sum = 0.0;
            for(i=0; i<1024; i++)
            {
                sum = sum + adc_data[i];
            }
            sum = sum / 1024;
            
            if(sum < current_threshold && t.read()== 0)
            {
                t.reset();
                t.start();
                rf_32Asafe = false;
            }
            
            if(sum < current_threshold && t.read() > time_threshold)
            {
                t.stop();
                rf_32Asafe = true;
                while(1){
                    }
            }
            
            if(sum > current_threshold)
            {
                t.reset();
                rf_32Asafe = false;
            } 
                
            data_ready = false;
            adc_data_counter = 0;               
        }      
    }
}
