/*
 * Copyright (c) 2016 M2C Ltd
 * TEST  32to16 with cp error sense/ Hyundai Corrected 16112016
 * 5000 samples
 * 3 second reset
 * if / else if / else - post insertation read
 */

#include "mbed.h"

AnalogIn cp_value(A1);      //A1 – PWM sense, analog read
AnalogIn pp_value(A2); //A2 - PP, analog reads
PwmOut my_pwm(D5);//pwm pin 5
DigitalOut lock(D7);
InterruptIn button(D8);

DigitalOut relay(D12);
DigitalOut contactor(D13);

Timer buttonTimer; //CC for reset button
Timeout buttonTimeout; //CC for reset button

DigitalOut green(D9);
DigitalOut red(D10);
DigitalOut blue(D11);



#define STATE_A 1           // Vehicle not connected
#define STATE_B 2           // Vehicle connected / not ready to accept energy
#define STATE_C 3           // Vehicle connected / ready to accept energy / ventilation not required
#define STATE_D 4           // Vehicle connected / ready to accept energy / ventilation required

#define PILOT_12V      1
#define PILOT_9V_16    2
#define PILOT_6V_16    3 
#define PILOT_9V_32    4
#define PILOT_6V_32    5
#define PILOT_RESET    6
#define PILOT_NOK      7 

float current_average=0;
float previous_average=0;
unsigned char control_pilot;

#define NUM_SAMPLES 5000 // size of sample series

#define SAMPLE_BLOCKS 1 //CC for reset button
#define RESET_SECONDS 3 //CC for reset button

bool resetDown = false;
bool resetCharger = false;

void timedOut()
{
    resetCharger = true;
    printf("Button pressed for more than 3 sec ! Charger reset !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \r\n");
}

void resetPress()
{
    printf("Reset button pressed ... starting timer \r\n");
    buttonTimer.stop();
    buttonTimer.reset();
    buttonTimer.start();
    resetDown = true;
    buttonTimeout.attach(&timedOut, RESET_SECONDS);
}

void resetRelease()
{
    printf("Reset button released \r\n");
    int elapsedSeconds = buttonTimer.read();
    buttonTimer.stop();
    buttonTimer.reset();
    if (elapsedSeconds > 3) {
        resetCharger = true;
        printf("Button was pressed for more than 3 sec !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \r\n");
    } else {
        printf("If we're getting here then we've released the button before 3 seconds were up.\r\n");
    }
    printf("We will detach the timeout an setup for the next time.\r\n");
    printf("%u \r\n", elapsedSeconds);
    buttonTimeout.detach();
}

int main()
{

    button.fall(&resetPress);
    button.rise(&resetRelease);

    while(1) {

        float readingA2 = pp_value.read();
        readingA2 = readingA2 * 3300;

        for (int i = 0; i < NUM_SAMPLES ; i++) {
            float sample_value = cp_value.read_u16();
            sample_value = (float) 3300 / 65535 * (float) sample_value;  // convert sample to voltage
            current_average = ((sample_value + (i * previous_average)) / (i+1));
            previous_average = current_average;
        }
        printf("PP Pilot Value = %.0f mV\n\r",readingA2);
        printf("CP avrg. Value %.f \n\r", current_average);
        



//*********************   TEST CONVEX BUILD Hyundai 32/16 ***********************//
if(readingA2>3200) 
{
    printf("cable out \n\r");
    
    if ((current_average > 2650) &&  (current_average < 2750)){        
            control_pilot = PILOT_12V;    // Pilot at 12V 
    }
    if (current_average < 100){ // first reading ˜2702 & ˜755 after         
            control_pilot = PILOT_12V;    // Pilot at 12V 
            resetCharger = false;
    } 
}

if(readingA2<3200)
{
       //16amp cable in
        if((readingA2>150)&&(readingA2<300)){ 
            
            if((resetCharger == true)||(current_average < 100)){
                control_pilot = PILOT_RESET;
                printf("reset @ 16\n\r");
            }
            else if ((current_average > 2650) &&  (current_average < 2750))
            {         
            control_pilot = PILOT_12V;    // Pilot at 12V 
            printf("16A cable in -no car \r\n");
            printf("12 @ 32\n\r");
            }
            else if((current_average > 1900) &&  (current_average <2100) || (current_average > 550) &&  (current_average <650))
            {    
                control_pilot = PILOT_9V_16;    // Pilot at 9V   
                printf("9 @ 16 \r\n");    
            }
            else if((current_average> 400) && (current_average<500)) {      
                control_pilot = PILOT_6V_16;    // Pilot at 6V
                printf("6 @ 16 \r\n");        
            }
            /*else if (current_average < 100){ // first reading ˜2702 & ˜755 after        
                control_pilot = PILOT_RESET;
                printf("car gone so @ 16");
            }
            */ 
            else {
                control_pilot = PILOT_NOK;
                printf("NOT OK @ 16 \r\n");
            }
            
        }
        
        //32amp cable in
        if((readingA2> 0)&&(readingA2<100))
        {
            if((resetCharger == true)||(current_average < 100))
            {
                control_pilot = PILOT_RESET;
                printf("reset @ 32\n\r");
            }
            else if ((current_average > 2650) &&  (current_average < 2750)) // first reading ˜2702 & ˜755 after 
            {         
            control_pilot = PILOT_12V;    // Pilot at 12V 
            printf("32A cable in -no car \r\n");
            printf("12 @ 32\n\r");
            }
            else if((current_average > 1900) &&  (current_average <2100) || (current_average > 1070) &&  (current_average <1170)) // first reading ˜2012 & ˜573 after
            {    
                control_pilot = PILOT_9V_32;    // Pilot at 9V   
                printf("9 @ 32 \r\n");     
            }
            else if((current_average> 730) && (current_average<870)) 
            {       
                control_pilot = PILOT_6V_32;    // Pilot at 6V       
                printf("6 @ 32 \r\n"); 
            }
            /*else if (current_average < 100){ // first reading ˜2702 & ˜755 after        
                control_pilot = PILOT_RESET;
                printf("car gone so @ 32");
            }
            */
            else {
                control_pilot = PILOT_NOK;
                printf("NOT OK @ 32 \r\n"); 
            }
        }
}
        
        
        switch(control_pilot) {
        case PILOT_12V:
            printf("Charger in STATE A\r\n");
            //printf("PILOT_12V - Pilot at 12 V \n\r");
            contactor =0;
            my_pwm.write(0);
            lock=0;
            red = 0;
            green = 0;
            blue = 1;
            break;
  
        case PILOT_9V_16:
            contactor =0;
            //relay=0;
            lock=1;
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(0.734);         
            printf("Charger in STATE b\r\n");
            //printf("PILOT_9V 16- Pilot at 9 V \n\r");
            red = 1;
            green = 1;
            blue = 0;
            break;
                
        case PILOT_6V_16:
            contactor =1;
            relay=1;
            lock=1;
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(0.734);                    
            printf("Charger in STATE c\r\n");
            //printf("PILOT_6V 16- Pilot at 6 V \n\r");
            red = 0;
            green = 1;
            blue = 0;
            break;
            
        case PILOT_9V_32:
            contactor =0;
            //relay=0;
            lock=1;
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(0.468);         
            printf("Charger in STATE b\r\n");
            //printf("PILOT_9V 32- Pilot at 9 V \n\r");
            red = 1;
            green = 1;
            blue = 0;
            break;
                
        case PILOT_6V_32:
            contactor =1;
            relay=1;
            lock=1;
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(0.468);                    
            printf("Charger in STATE c\r\n");
            //printf("PILOT_6V 32- Pilot at 6 V \n\r");
            red = 0;
            green = 1;
            blue = 0;
            break;
            
        case PILOT_RESET:
            printf("RESET IMPLEMENTED \n\r");
            //printf("PILOT_RESET - Pilot at -12V \n\r");
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(1);
            contactor =0;
            relay=0;
            lock=0;
            red = 0;
            green = 0;
            blue = 1;
            wait(0.5); // 200 ms
            blue = 0; // LED is OFF
            wait(0.2); // 1 sec
            break;
            
        case PILOT_NOK:
            printf("Error");
            printf("PILOT_NOT OK - Pilot readding incorect \n\r");
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(1);
            contactor =0;
            relay=0;
            lock=0;
            red = 1;
            green = 0;
            blue = 0;
            break;
        }//end switch

        printf("############## 32/16 with error 16112016 ###\n\r");
        //wait(2);
    }//end while (1)
    
    
}//end main()