/**
 * Copyright (c) 2016 M2C Ltd
 * TEST 10.8A  (18% PWM) for first Convex build / Mick's dad house
 
 2000 samples 
 
 3 second reset
 *
 */

#include "mbed.h"

AnalogIn cp_value(A1);      //A1 – PWM sense, analog read
AnalogIn pp_value(A2); //A2 - PP, analog reads
PwmOut my_pwm(D5);//pwm pin 5
DigitalOut lock(D7);
InterruptIn button(D8);

DigitalOut relay(D12);
DigitalOut contactor(D13);

Timer buttonTimer; //CC for reset button
Timeout buttonTimeout; //CC for reset button

DigitalOut green(D9);
DigitalOut red(D10);
DigitalOut blue(D11);

unsigned char control_pilot;

#define STATE_A 1           // Vehicle not connected
#define STATE_B 2           // Vehicle connected / not ready to accept energy
#define STATE_C 3           // Vehicle connected / ready to accept energy / ventilation not required
#define STATE_D 4           // Vehicle connected / ready to accept energy / ventilation required

#define PILOT_12V   1
#define PILOT_9V    2
#define PILOT_6V    3
#define PILOT_DIODE 4 
#define PILOT_NOK   0
#define PILOT_RESET 5

float current_average=0;
float previous_average=0;
#define NUM_SAMPLES 2000 // size of sample series

#define SAMPLE_BLOCKS 1 //CC for reset button
#define RESET_SECONDS 3 //CC for reset button

bool resetDown = false;
bool resetCharger = false;

void timedOut() {
    resetCharger = true;
    printf("Button pressed for more than 3 sec ! Charger reset !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \r\n");
}
 
void resetPress() {
    printf("Reset button pressed ... starting timer \r\n");
    buttonTimer.stop();
    buttonTimer.reset();
    buttonTimer.start();
    resetDown = true;   
    buttonTimeout.attach(&timedOut, RESET_SECONDS);   
}
    
void resetRelease() {
    printf("Reset button released \r\n");
    int elapsedSeconds = buttonTimer.read();
    buttonTimer.stop();
    buttonTimer.reset();
    if (elapsedSeconds > 3) {
        resetCharger = true;
        printf("Button was pressed for more than 3 sec !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! \r\n");
    }
    else{
    printf("If we're getting here then we've released the button before 3 seconds were up.\r\n");
    }
    printf("We will detach the timeout an setup for the next time.\r\n");
    printf("%u \r\n", elapsedSeconds);
    buttonTimeout.detach();
}
 
int main() {
        
    button.fall(&resetPress);
    button.rise(&resetRelease);

    while(1) {
               
    float readingA2 = pp_value.read();

    readingA2 = readingA2 * 3300;

 for (int i = 0; i < NUM_SAMPLES ; i++)
        {
            float sample_value = cp_value.read_u16();
            sample_value = (float) 3300 / 65535 * (float) sample_value;  // convert sample to voltage
            current_average = ((sample_value + (i * previous_average)) / (i+1));
            previous_average = current_average; 
        }
printf("current_average %.f \n\r", current_average);
printf("PP Pilot Value = %.0f mV\n\r",readingA2);
        
  
  
//*********************   TEST CONVEX BUILD***********************//
if(readingA2>3200) 
{
    
    if ((current_average > 2600) &&  (current_average < 2750) || (current_average > 370) && (current_average < 470)) // first reading ˜2702 & ˜755 after 
    {        
            control_pilot = PILOT_12V;    // Pilot at 12V 
    }
    if (current_average < 100) // first reading ˜2702 & ˜755 after 
    {        
            control_pilot = PILOT_12V;    // Pilot at 12V 
            resetCharger = false;
    }

        
}
if(readingA2<3200) // tester 32A cable
{
       
        if((current_average > 1900) &&  (current_average <2100) || (current_average > 400) &&  (current_average <470)) // first reading ˜2012 & ˜573 after
        {      
            control_pilot = PILOT_9V;    // Pilot at 9V       
        }
        if((current_average> 270) && (current_average<350)) // first reading ˜1372 & ˜405 after
        {       
            control_pilot = PILOT_6V;    // Pilot at 6V       
        }
        if(resetCharger == true)
        {control_pilot = PILOT_RESET;}
        
}//end if(readingA2!=0) 
  
        
/*
if(readingA2>3200) 
{
    
    if ((current_average > 2650) &&  (current_average < 2750) || (current_average > 700) && (current_average < 800)) // first reading ˜2702 & ˜755 after 
    {        
            control_pilot = PILOT_12V;    // Pilot at 12V 
    }
    if (current_average < 100) // first reading ˜2702 & ˜755 after 
    {        
            control_pilot = PILOT_12V;    // Pilot at 12V 
            resetCharger = false;
    }

        
}
if(readingA2<3200) // tester 32A cable
{
       
        if((current_average > 1900) &&  (current_average <2100) || (current_average > 500) &&  (current_average <600)) // first reading ˜2012 & ˜573 after
        {      
            control_pilot = PILOT_9V;    // Pilot at 9V       
        }
        if((current_average> 350) && (current_average<450)) // first reading ˜1372 & ˜405 after
        {       
            control_pilot = PILOT_6V;    // Pilot at 6V       
        }
        if(resetCharger == true)
        {control_pilot = PILOT_RESET;}
        
}//end if(readingA2!=0) 
*/


        switch(control_pilot) {
        case PILOT_12V:
            printf("Charger in STATE A\r\n");
            printf("PILOT_12V - Pilot at 12 V \n\r");
            my_pwm = 0;
            contactor =0;
            lock=0;
            red = 0;
            green = 0;
            blue = 1;
            break;
  
        case PILOT_9V:
            contactor =0;
            //relay=0;
            lock=1;
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(0.820);                    ///////PWM CHANGED from my_pwm.write(0.734);
            printf("Charger in STATE b\r\n");
            printf("PILOT_9V - Pilot at 9 V \n\r");
            red = 1;
            green = 1;
            blue = 0;
            break;
                
        case PILOT_6V:
            contactor =1;
            relay=1;
            lock=1;
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(0.820);                    ///////PWM CHANGED from my_pwm.write(0.734);

            printf("Charger in STATE c\r\n");
            printf("PILOT_6V - Pilot at 6 V \n\r");
            red = 0;
            green = 1;
            blue = 0;
            break;
                   
        case PILOT_NOK:
            printf("Error");
            printf("PILOT_NOK - Pilot ERROR \n\r");
            lock=0;
            red = 1;
            green = 0;
            blue = 0;
            break;
            
        case PILOT_RESET:
            printf("RESET IMPLEMENTED \n\r");
            printf("PILOT_RESET - Pilot at -12V \n\r");
            my_pwm.period_ms(1);
            my_pwm.pulsewidth_ms(1);
            my_pwm.write(1);
            contactor =0;
            relay=0;
            lock=0;
            red = 1;
            green = 0;
            blue = 0;
            wait(0.5); // 200 ms
            red = 0; // LED is OFF
            wait(0.2); // 1 sec
            break;
            
        }//end switch
     
printf("#################\n\r");          
}//end while (1)
}//end main()