#include "mbed.h"
#include "DHT.h"                                                                // on inclue la librairie

DigitalOut myled(LED1);                                                         // on utilisera la led embarqué sur la carte
DHT dht11(PB_10,DHT11);                                                         // on déclare le capteur (connecté sur le port DIO_D6 de la carte L073RZ)

int main()
{
    int err;
    float temperature;
    float humidite;
    float point_rose;

    while(1) {
        // Utilisation du capteur DHT11
        err = dht11.readData();                                                 // récupération des données
        if (err == 0) {
            temperature = dht11.ReadTemperature(CELCIUS);
            humidite = dht11.ReadHumidity();
            point_rose = dht11.CalcdewPoint(dht11.ReadTemperature(CELCIUS), dht11.ReadHumidity());
            printf("Temperature : %4.2f C \n",temperature);                    // envoie sur le port série des données (par défaut 9600bauds)
            printf("Humidite : %4.2f % \n",humidite);
            printf("Point rose : %4.2f C \n",point_rose);
        } else
            printf("\r\nErreur %i \n",err);

        // Clignotement de la led
        myled != myled;
        
        wait(2);
    }
}
