#include "mbed.h"
#include "Grove_temperature.h"
#include "DHT.h"
#include "SSD1308.h"

DigitalOut myled(LED2);           //Create a DigitalOut object named "myled", it's connected to Pin LED2.
Grove_temperature temp_obj(A1);   //Create a Crove_temperature object named "temp_obj", it's connected to Pin  A1.
DHT dht11(D6,DHT11);              //Create a DHT object named "dht11", it's connected to Port D6.   
AnalogIn potar(A3);               //Create a varialbe resisitor object named "potar", it's connected to Pin A3.
I2C i2c(PB_9,PB_8);               //OLED is connected to the L073RZ's I2C port.
SSD1308 oled(&i2c, SSD1308_SA0);  //Create a SSD1308 object named "oled".    

int main(void)
{
    
    while (true) {
/****************************************** For Class 1 and Class 2 **************************************************/        
        
//        /* Part1: LED test */
//        printf("*** Part1: LED test ***\n");
//        myled = !myled;
//        if(myled == 1)
//            printf("Led2 is on!\n\n");
//        else
//            printf("Led2 is off!\n\n");
//        wait(1);
//        
//        /* Part2: NTC temperature sensor */
//        printf("*** Part2: NTC temperature sensor ***\n");
//        printf("temperature = %2.2f\n\n", temp_obj.getTemperature());
//        wait(1);
//        
//        /* Part3: Variable resistor */
//        printf("*** Part3: Variable resistor ***\n");
//        printf("Percentage value: %3.3f%%\n", potar.read()*100.0f);
//        printf("Normal value(0-1): %3.3f\n\n", potar.read_u16()/65535.0);
//        wait(1);
//        
//        /* Part4: DHT11 temperature and humidity sensor */
//        printf("*** Part4: DHT11 temperature and humidity sensor ***\n");
//        int err;
//        float temperature;
//        float humidite;
//        float point_rose;
//        
//        err = dht11.readData();   // Get the data from the sensor and the return value of the function is to judge if any error happened.
//        if (err == 0) {           // No errors happened
//            temperature = dht11.ReadTemperature(CELCIUS);
//            humidite = dht11.ReadHumidity();
//            point_rose = dht11.CalcdewPoint(dht11.ReadTemperature(CELCIUS), dht11.ReadHumidity());
//            printf("Temperature : %4.2f C \n",temperature); // send the data to the serial port connected to PC(9600bauds).
//            printf("Humidite : %4.2f %% \n",humidite);
//            printf("Point rose : %4.2f C \n\n",point_rose);
//        } else
//            printf("\r\nErreur %i \n\n",err);
//        
//        wait(1);
//        
//        /* Part5: OLED SSD1308 */
//        printf("*** Part5: OLED SSD1308 ***\n\n");
//        oled.writeString(0, 0, "Hello mbed !");
//        wait(1);
//        oled.clearDisplay();
//        
//        wait(1);

/****************************************** For Class 3 ****************************************************************/

        
        /* Part6: The valus of the three sensors will be displayed on the OLED */
        printf("*** Part6: The valus of the three sensors will be displayed on the OLED ***\n");
        
        //
        // title
        oled.writeString(0,2,"SmartCampus");
        
        //
        // public variables
        char str[10];         //store the conversion( float-to-char ) result.
        
        //
        // NTC value
        oled.writeString(2,0,"NTC:");
        oled.writeString(2,15,"C");
      
        float ntc_temp = temp_obj.getTemperature();   
        sprintf(str,"%4.3f",ntc_temp);      //data type conversion.
        oled.writeString(2,4,str);
        
        //
        // variable resister
        oled.writeString(3,0,"VarRes:");

        float var_res = potar.read();
        sprintf(str,"%4.3f",var_res);       //data type conversion.
        oled.writeString(3,7,str);
        
        //
        // DHT11
        oled.writeString(4,0,"DHT11");
        oled.writeString(5,0,"Temp:");
        oled.writeString(5,15,"C");
        oled.writeString(6,0,"Humi:");   
        oled.writeString(6,15,"%");    
        
        int err = 0;
        float temperature;
        float humidity;
        
        err = dht11.readData();   // Get the data from the sensor and the return value of the function is to judge if any error happened.
        if (err == 0)             // No errors happened
        {           
            temperature = dht11.ReadTemperature(CELCIUS);
            humidity = dht11.ReadHumidity();
            
            sprintf(str,"%4.3f",temperature);       //data type conversion.
            oled.writeString(5,5,str);
            sprintf(str,"%4.3f",humidity);          //data type conversion.
            oled.writeString(6,5,str);
            
            oled.writeString(7,0,"                ");   //If errors have been solved ,then clear the errors.         
        } else
        {
            oled.writeString(7,0,"DHT11 Error");     
            printf("%d\n",err);
        }
               
        wait(1);
    }
    
}
