#include "mbed.h"
#include "SSD1308.h"
#include "logo.h"
#include "Grove_temperature.h"
#include "DHT.h"
#include<stdio.h>

////OLED
I2C i2c(PB_9,PB_8);                                                             
SSD1308 oled = SSD1308(&i2c, SSD1308_SA0);
/////////////
Grove_temperature temp(PA_1);    //thermistance

DigitalOut myled(LED1);   //DHT11                                                      // we will use the led embedded on the map
DHT dht11(PB_10,DHT11);  

AnalogIn   potar(A3);  //potaranalogic   

/////////////
InterruptIn mybutton(USER_BUTTON);
int j=1;
int count=1;
int tem1[30];

void pressed()
{  
    oled.clearDisplay_zone(); //clear the zone of displaying graph
    j++;
    if(j>4)j=1;
    count=1;
    for(int t=0;t<30;t++)
    tem1[t]=32; ///The data is line 32 of the grah2_point[][4] array, which is {0x00,0x00,0x00,0x00}
    
}


//////main
int main() {
   int i;  
   float x;
  
 
  
   int err;
   float temperature;
   float humidite;
    
   char buffer_1[10];
   char buffer_2[10];
   char buffer_3[10];
   char buffer_4[10];  
   
   oled.display_Axis_y();
   oled.display_Axis_x();  
    
   while (true) 
   {
     mybutton.fall(&pressed);
     switch(j)
        {case 1:
                for(i=0;i<30;i++)     
                    { 
                          x=temp.getTemperature();
                          if(count==1)tem1[i]=(int)(x-15);//offset
                          else
                            {   
                                for(int m=0;m<29;m++)
                                { tem1[m]=tem1[m+1]; }
                                tem1[29]=(int)(x-15);
                            }
                            
                          printf("temperature = %2d\n", tem1[i]);
                          sprintf(buffer_1, "tem_NTC: %5.2f C",x);
                          oled.setHorizontalAddressingMode();
                          oled.writeString(0,0,buffer_1); 
                         
                         if(j!=1) 
                           {
                              oled.clearDisplay_zone(); //clear the zone of displaying graph
                              i=30;                     //End the loop
                              count=1;
                              for(int t=0;t<30;t++) //Empty array
                              tem1[t]=32;          ///The data is line 32 of the grah2_point[][4] array, which is {0x00,0x00,0x00,0x00}        
                           }
                          else if(count==1)  oled.graph(tem1,i,count);
                          else if(count!=1)  oled.graph(tem1,30,count);            
                    }
                count++;                
                break;
            
          case 2: //////display temperature of DHT11           
                for(i=0;i<30;i++)                   
                   {
                        err = dht11.readData();                                                 // data recovery
                        if (err == 0) {
                            temperature = dht11.ReadTemperature(CELCIUS);                            
                            if(count==1) tem1[i]=(int)(temperature-15);
                            else
                            {   
                                for(int m=0;m<29;m++)
                                { tem1[m]=tem1[m+1]; }
                                tem1[29]=(int)(temperature-15);
                            }                               
                            printf("Temperature : %4.2f C \n",temperature);                    // sends data serial port (default 9600bauds)   
                             
                                                                              
                        }
                         else  {
                            printf("\r\nErreur %i \n",err);
                            tem1[i]=32;
                        }
                        
                        sprintf(buffer_2, "Tem_DHT: %5.2f C", temperature);
                        oled.setHorizontalAddressingMode();
                        oled.writeString(0,0,buffer_2);                                                
                       
                       if(j!=2) 
                       {
                          oled.clearDisplay_zone();
                          i=30;
                          count=1;
                          for(int t=0;t<30;t++)
                          tem1[t]=32;
                       }                                                
                       else if(count==1)  {oled.graph(tem1,i,count); wait(2.1);}
                       else if(count!=1)  {oled.graph(tem1,30,count); wait(2.1);}
                    }
                count++; 
                break;
                
          case 3: //////////display humidite of DHT11         
                for(i=0;i<30;i++)                   
                   {
                        err = dht11.readData();                                                 // data recovery
                        if (err == 0) {                           
                            humidite = dht11.ReadHumidity();                           
                            if(count==1) tem1[i]=(int)(humidite/5);
                            else
                            {   
                                for(int m=0;m<29;m++)
                                { tem1[m]=tem1[m+1]; }
                                tem1[29]=(int)(humidite/5);
                            }                        
                            printf("Humidite : %4.2f %% \n",humidite);
                            
                        }
                         else
                            printf("\r\nErreur %i \n",err);
                             
                        
                        sprintf(buffer_3, "Hum_DHT: %5.2f%% ", humidite);
                        oled.setHorizontalAddressingMode();
                        oled.writeString(0,0,buffer_3); 
                        
                        if(j!=3) 
                        {
                          oled.clearDisplay_zone();
                          i=30;
                          count=1;
                          for(int t=0;t<30;t++)
                          tem1[t]=32;
                        }   
                        else if(count==1)  {oled.graph(tem1,i,count); wait(2.1);}
                        else if(count!=1)  {oled.graph(tem1,30,count); wait(2.1);}
                    }
                count++; 
                break;
                
            case 4: ////////////////////potaranalogic                 
                  for(i=0;i<30;i++)
                   { 
                        x=potar.read_u16()/65535.0;
                        if(count==1) tem1[i]=(int)(x*25);
                        else
                            {   
                                for(int m=0;m<29;m++)
                                { tem1[m]=tem1[m+1]; }
                                tem1[29]=(int)(x*25);
                            }
                        printf("normalized value(0-1):%3.3f\n",x);
                                             
                        sprintf(buffer_4, "potarlogic:%5.2f", potar.read_u16()/65535.0);
                        oled.setHorizontalAddressingMode();
                        oled.writeString(0,0,buffer_4);
                        
                        if(j!=4) 
                        {
                          oled.clearDisplay_zone();
                          i=30;
                          count=1;
                          for(int t=0;t<30;t++)
                          tem1[t]=32;
                        }   
                       else if(count==1)  {oled.graph(tem1,i,count); wait(1);}
                       else if(count!=1)  {oled.graph(tem1,30,count); wait(1);}
                    }
                 count++; 
                 break;
            
         }
          
    }      
                            
}

