#include "wave.h"

Temperature::Temperature(void)
{
    u8_page = 7;
    u8_col = 127;
    u8_temperature = 0;
    u8_value = 0;
}

Temperature::~Temperature(void)
{
    
}

void Temperature::calcPage(void)        //calculate the display page of this temperature
{
    uint8_t tmp;
    tmp = u8_temperature / 8;
    u8_page = 7 - tmp;  //7 - tmp
}

void Temperature::calcValue(void)       //calculate the I2C value of this temperature
{
    uint8_t index;
    
    index = 7 - ( u8_temperature % 8 );
    u8_value = (0x01) << index;
}