#include "mbed.h"
#include "SSD1308.h"
#include "wave.h"
#include "star.h"

#define NUM_STAR 8
#define SPEED 100

AnalogIn random(A2);
AnalogIn varRes(A3);                                                            //variable resistor
I2C i2c(PB_9,PB_8);                                                             //The OLED uses port I2C to connect to the L073RZ
SSD1308 oled = SSD1308(&i2c, SSD1308_SA0);

uint8_t off = 0x00;
uint8_t on = 0xFF;
uint8_t cursorCol = 0;
uint8_t cursorLastPage = 255,cursorCurPage = 255;
uint8_t err = 1;

void cursorRefresh(void);

Star s[NUM_STAR];

int main() {
    uint8_t tmp1 = 0,tmp2 = 0;
    uint8_t score = 0,total = 0;
    char buffer[10]; //store string
    uint8_t speed = SPEED;
    int8_t i;
    
    for(i = 0;i < 8;i++)
    {
        oled.writeBitmap(&on,i,i,65,65);   //draw a line    
    }
    oled.writeString(0,9,"Score");
    oled.writeString(1,9,"  0");
    oled.writeString(3,9,"Total");
    oled.writeString(4,9,"  0");
    
    s[0].u8_col = 1;
    for(i = NUM_STAR - 1;i > 0;i--)
    {
        s[i].u8_col = i * 8;
    }

    while(1){
        //refresh cursor
        if(err == 0){
            cursorRefresh();
            wait_ms(10);      
            tmp1++;
        }
        else{
            oled.writeBitmap(&off,cursorLastPage,cursorLastPage,cursorCol,cursorCol);   //clear last page
            oled.writeBitmap(&on,cursorCurPage,cursorCurPage,cursorCol,cursorCol);               
            cursorRefresh();
            wait_ms(10); 
        }  
        
        //refresh stars
        if(tmp1 == speed)
        {
            tmp2 = (long int)(random.read() * 1000000) % 1000000 % 100000 % 10000 % 1000 % 100 % 64;
            //printf("\r\n %d \r\n",tmp2);    
            
            for(i = 0;i < NUM_STAR;i++)
            {
                oled.writeBitmap(0,s[i].u8_page,s[i].u8_page,s[i].u8_col,s[i].u8_col);
            }
            
            for(i = 0;i < NUM_STAR - 1;i++)
            {
                s[i].u8_page = s[i + 1].u8_page;
                s[i].u8_star = s[i + 1].u8_star;
                s[i].u8_value = s[i + 1].u8_value;
            }
            s[NUM_STAR - 1].u8_star = tmp2;
            s[NUM_STAR - 1].calcPage();
            s[NUM_STAR - 1].calcValue();  
                      
            for(i = 0;i < NUM_STAR;i++)
            {
                oled.writeBitmap(&s[i].u8_value,s[i].u8_page,s[i].u8_page,s[i].u8_col,s[i].u8_col);
            }
            
            //calculate score
            if(s[0].u8_page == cursorCurPage)
            {
                score++;
                oled.writeBitmap(0,s[0].u8_page,s[0].u8_page,s[0].u8_col,s[0].u8_col);
                sprintf(buffer,"%3d",score);
                oled.writeString(1,9,buffer);
            }
    
            //Total statistics 
            total++;
            sprintf(buffer,"%3d",total);
            oled.writeString(4,9,buffer);
            
            tmp1 = 0;    
        }  
        
        //change speed
        if(score > 20){
            speed = 80;
        }
        else if(score > 50){
            speed = 60;
        }
        else if(score > 70){
            speed = 40;   
        }
        else if(score > 100){
            speed = 10;    
        }
        
        //game is over
        if((total - score) >= 30){
            oled.writeString(6,9,"Over!");
            return 0;    
        }
        
    }
}

void cursorRefresh(void)
{
    cursorLastPage = cursorCurPage;
    cursorCurPage = (uint8_t)(varRes.read() * 255.0 / 32.0); 
    err = cursorCurPage - cursorLastPage;        
}