#include "mbed.h"
#include "SSD1308.h"
#include "wave.h"
#include "Grove_temperature.h"

#define NUM_TEMP 64 //The number of points that will be displayed on the OLED

AnalogIn varRes(A3);    //variable resistor
Grove_temperature temp_obj(A1);   //Create a Crove_temperature object named "temp_obj", it's connected to Pin  A1.
I2C i2c(PB_9,PB_8);               //The OLED uses port I2C to connect to the L073RZ
SSD1308 oled = SSD1308(&i2c, SSD1308_SA0);

void tempArrayInit(Temperature *p);         //temperature struct initialization
void tempArrayRefresh(Temperature *p);      //temperature struct refresh
void tempArrayDisplayOnOLED(Temperature *p);//temperature struct display the point on the OLED

int main() {
    Temperature t[NUM_TEMP];  //temperature array
    char buffer[10];          //store a string
    int interval;               //refresh time
             
    tempArrayInit(t);           //temperature array initialization
    oled.clearDisplay();
    while(1){
        interval = (int)(varRes.read() * 200);  //variable resistor control the refresh speed
        wait_ms(interval);        
        
        tempArrayRefresh(t);    //refresh the array
        tempArrayDisplayOnOLED(t);      //display the pixel about the tempearture
    
        sprintf(buffer," T:%2dC",t[NUM_TEMP - 1].u8_temperature);     //sprintf the temperature to the buffer
        oled.writeString(3,8,buffer);  
//        sprintf(buffer," t:%3dms",interval);     //sprintf the temperature to the buffer
//        oled.writeString(5,8,buffer);                
    }
}

void tempArrayInit(Temperature *p)
{
    uint8_t i;
    for(i = 0;i < NUM_TEMP;i++){
        p[i].u8_col = i;
        p[i].u8_temperature = i % 64;
    }
}
void tempArrayRefresh(Temperature *p)
{
    //refresh array
    uint8_t i;
    for(i = 0;i < (NUM_TEMP - 1);i++){
        p[i].u8_page = p[i + 1].u8_page;
        //don't refresh the column
        //p[i].u8_col = p[i + 1].u8_col;
        p[i].u8_temperature = p[i + 1].u8_temperature;
        p[i].u8_value = p[i + 1].u8_value;
    }

    //get new value
    p[NUM_TEMP - 1].u8_temperature = (uint8_t)(temp_obj.getTemperature());
    
    //calculate value
    p[NUM_TEMP - 1].calcPage();
    p[NUM_TEMP - 1].calcValue();
}

void tempArrayDisplayOnOLED(Temperature *p)
{
    uint8_t i;
    
    for(i = 0;i < NUM_TEMP;i++){
        
        oled.writeBitmap(&p[i].u8_value,p[i].u8_page,p[i].u8_page,p[i].u8_col,p[i].u8_col);
        /* clear the data on other pages withins the same column*/
        for(uint8_t j = 0;j < 8;j++){
            if(j == p[i].u8_page){
                continue;
            }    
            else{
                oled.writeBitmap(0,j,j,p[i].u8_col,p[i].u8_col);
            }
        }
        
    }
}