#include "mbed.h"
#include <string>
#include <stdio.h>
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "PinDetect.h"

Serial pc(USBTX, USBRX);
uLCD_4DGL lcd(p28,p27,p24);
Serial xbee(p9, p10);
DigitalOut reset(p8);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
PinDetect getStatus(p16);
PinDetect toggleLight(p17);
PinDetect camPic(p18);

volatile bool statusReq = false;
volatile bool flipLed = false;
volatile bool cameraReq = false;

Thread t1;

char buffer[50];

void statusRequest()
{
    statusReq = true;
}

void flipLight()
{
    flipLed = true;
}

void cameraTakePic()
{
    cameraReq = true;
}

void sendcommand(char out)
{
        if(xbee.writeable()) {
            led2 = 1;
            char outbuf = out;
            xbee.putc(outbuf);
            pc.putc(outbuf);
            outbuf = ' ';
            led2 = 0;
        }
}

void getcommand()
{
    while(1) {
        if(xbee.readable()) {
            led1 = 1;
            int x = 0;
            while(xbee.readable()) {
                buffer[x] = xbee.getc();
                x++;
            }
            led1 = 0;
            bool statusmsg = true;
            // pc.printf(buffer);
            if(buffer[0] == 'p') {
                lcd.locate(0, 6);
                char msg[] = "Pic Taken,See Mbed";
                lcd.puts(msg);
                statusmsg = false;
            }
            else if (buffer[0] == 'i'){
                lcd.locate(0,6);
                char msg[] = "Intrusion Detected";
                lcd.puts(msg);
                lcd.media_init(); // initialize uSD card
                lcd.set_sector_address(0,0);  // address of font file
                lcd.media_init();
                lcd.display_image(0,60);
                Thread::wait(4000);
                statusmsg = false;
                lcd.filled_rectangle(0, 48, 128, 128, BLACK);
            } else if(buffer[0] == 'u'){
                lcd.locate(0,6);
                char msg[] = "Door Unlocked";
                lcd.puts(msg);
                Thread::wait(4000);
                lcd.locate(0,6);
                for(int i = 0; i < 18; ++i){
                    msg[i] = ' ';
                }
                lcd.puts(msg);
                statusmsg = false;
            }
            if(statusmsg == true) {
                const char s[2] = "|"; // s[2]
                char *token;
                token = strtok(buffer, s); // get the first token
                int j = 2;
                while( token != NULL ) { // walk through other tokens
                    lcd.locate(11,j);   // Print in correct place of LCD
                    lcd.puts(token );
                    token = strtok(NULL, s);
                    j++;
                }
            }
        }
    }
}

int main()
{
    reset = 0;
    wait_ms(1);
    reset = 1;
    wait_ms(1);

    getStatus.mode(PullDown);
    getStatus.attach_asserted( &statusRequest );
    getStatus.setSampleFrequency();

    toggleLight.mode(PullDown);
    toggleLight.attach_asserted( &flipLight );
    toggleLight.setSampleFrequency();

    camPic.mode(PullDown);
    camPic.attach_asserted( &cameraTakePic );
    camPic.setSampleFrequency();

    lcd.cls();
    lcd.locate(0,0);
    lcd.line(0, 5, 128, 5, 0xFF0000);
    lcd.printf("\r\nStatus:");
    lcd.printf("\r\n");
    lcd.printf("Temp degC:\r\n");
    lcd.printf("Humidity %:\r\n");
    lcd.printf("Lights: \r\n");
    lcd.line(0, 45, 128, 45, 0xFF0000);
    t1.start(getcommand);
    statusReq = true;

    while(1) {
        if (statusReq == true) {
            sendcommand('s');
            statusReq = false;
        } else if (flipLed == true) {
            sendcommand('l');
            flipLed = false;
        } else if(cameraReq == true) {
            sendcommand('c');
            cameraReq = false;
        }
        Thread::wait(2000);
    }
}