#include "mbed.h"
#include "rtos.h"
#include "JPEGCamera.h"
#include "Si7021.h"
#include "mpr121.h"
#include "math.h"

Serial xbee(p9, p10);
Serial pc(USBTX, USBRX);
JPEGCamera camera(p13, p14); // RED, Brown, pwr: Gray, gnd: Purple
LocalFileSystem local("local"); //save images on mbed

DigitalOut rst1(p8);

PwmOut light(p21);
Si7021 tempHum(p28, p27);

InterruptIn interrupt(p26);
I2C i2c(p28, p27); // Note here we don't need PullsUp coz Si7021 board has
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

AnalogIn photocell(p15);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int Nums[4] = {0,0,0,0};
int counter = 0;
int attempts = 0;

char outBuffer[50];
volatile char inBuffer;
volatile bool lightOnOff = true;
volatile bool requestIn = false;
volatile bool intrusion = false;
volatile bool unlockstatus = false;
volatile float photoval = 0.0;
int fileIndex = 0;

Thread t1;
Thread t2;

void getcommand()
{
    while(1) {
        if(xbee.readable()) {
            inBuffer = xbee.getc();
            requestIn = true;
        }
        Thread::wait(1000);
    }
}

void sendcommand(char outBuff[])
{
    if(xbee.writeable()) {
        int i = 0;
        while(outBuff[i] != ',') {
            xbee.putc(outBuff[i]);
            i++;
        }
    }
}

void statusUpdate()
{
    tempHum.measure();
    float temp = (tempHum.get_temperature()/1000.00);
    float hum = (tempHum.get_humidity()/1000.00);
    float lightStatus = light;
    char delimit = '|';
    char terminate = ',';
    sprintf(outBuffer, "%c%2.2f%c%2.2f%c%0.2f%c",delimit, temp, delimit, hum, delimit, lightStatus, terminate);
    sendcommand(outBuffer);
}

void checkUnlock();

void fallInterrupt()
{
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    i=0;
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) {
            key_code=i;
            Nums[counter] = key_code;
            counter++;
        }
    }

    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
    if(counter == 4) {
        checkUnlock();
    }
}

void checkUnlock()
{
    if(Nums[0] == 4 && Nums[1] == 1 && Nums[2] == 8 && Nums[3] == 0) {
        unlockstatus = true;
        attempts = 0;
    } else if(attempts < 1) {
        attempts = attempts + 1; // First attempt
    } else if (attempts == 1) { // Second attempt
        attempts = 0; // Reset attempts
        led1 = 1;
        led2 = 1;
        led3 = 1;
        led4 = 1;
        intrusion = true;
        attempts = 0;
    }
    counter = 0;
}


void cameraImage()
{
    if (camera.isReady()) {
        char filename[32];
        sprintf(filename, "/local/pict%d.jpg",fileIndex);
        fileIndex++;
        printf("Picture: %s ", filename);
        if (camera.takePicture(filename)) {
            while (camera.isProcessing()) {
                camera.processPicture();
            }
        }
    }
}


int main()
{
    camera.setPictureSize(JPEGCamera::SIZE320x240);
    light = 0;
    rst1 = 0;
    wait_ms(1);
    rst1 = 1;
    wait_ms(1);
    t1.start(getcommand);
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    inBuffer = 's';
    while(1) {
        photoval = 0.1/(0.1 + photocell);
        float newlight = (lightOnOff == true) ? photoval : 0.0;
        bool lighton = false;
        if(newlight == 0.0) {
            light = 0.0;
        } else if(fabs(newlight - light) > 0.05) {
            light = newlight;
            lighton = true;
        }
        if(intrusion || requestIn || inBuffer != ' ' || lighton || unlockstatus) { // Check for input request msg
            if(inBuffer == 's' || lighton) { // Send the status
                statusUpdate();
                inBuffer = ' ';
            } else if(unlockstatus) {
                light = 0.1/(0.1 + photocell);
                sendcommand("u,");
                unlockstatus = false;
                lightOnOff = true;
            } else if(inBuffer == 'l') {
                lightOnOff = !lightOnOff;  // Toggle light on/off
                inBuffer = 's';
            } else if(intrusion || inBuffer == 'c' ) {
                cameraImage(); // Capture pic & save locally
                if(intrusion) {
                    sendcommand("i,");
                    intrusion = false;
                } else {
                    sendcommand("p,");
                    inBuffer = ' ';
                }
            }
        }
        Thread::wait(500);
    }
}