//Multifunktionsblinker
//Hardware: Freescale FRDM KL25Z & SaintSmart LCD Keypad Shield
//Copyright: Andre Ehwein, Marcel Berrang, Daniel Knopp

#include "mbed.h"                                                       //Allgemeine Bib. für mbed
#include "TextLCD.h"                                                    //Bib. für den LCD Shield

DigitalOut Blinker_L_Led(PTD2);                                         // Digitaler Ausgang für den linken Blinker
DigitalOut Blinker_R_Led(PTD3);                                         // Digitaler Ausgang für den rechten Blinker
DigitalOut Licht(PTA12);                                                // Digitaler Ausgang für das Licht  

AnalogIn KEYS(PTB0);                                                    //AnalogIn um die Spannung zu bestimmen und die Buttons zu erkennen
TextLCD lcd(PTA13, PTD5, PTA4, PTA5, PTC8, PTC9, TextLCD::LCD16x2);     //Konfiguration des LCD-Keypad-Shields mit Pins: rs, e, d4, d5, d6, d7

//Definition der Tasten des Keypad Shields
#define RIGHT_KEY   0
#define UP_KEY      1
#define DOWN_KEY    2
#define LEFT_KEY    3
#define SELECT_KEY  4
#define NO_KEY      5                                                 

//Variablendefinition
int read_KEY();                                                         //Eingang Keypad
int buttonState;  
float z = 0.35;                                                         //Blinkrythmus
float wt=0.4;                                                           //Wartezeit vor Tastenerfassung (wichtig)
                                                

//Definition der Unterprogramme
void BlinkerL();
void BlinkerR();
void BlinkerW();
void Programmwahl();

//Hauptprogramm  
int main()
{                           
    lcd.cls();                                                          //LCD rücksetzen
    lcd.locate(3,0);                                                    //Posiiton der Anzeige festlegen
    lcd.printf("Welcome To");                                           //Textausgabe auf LCD 
    lcd.locate(4,1);
    lcd.printf("smartBIG");
    char h;                                                             //Schleife für Willkomenslicht
        for (h=2; h>=1; h--)
            {
                Licht=0;
                wait(0.2);
                Licht=1;
                wait(0.2);
            }
    wait(1);
      
    Programmwahl();                                                     //Aufruf der Programmauswahl
}

//Unterprogramm Programmwahl
void Programmwahl()
{
    Blinker_L_Led = 0;                                                  //Blinker zurücksetzen
    Blinker_R_Led = 0;
    lcd.cls();
    lcd.locate(4,1);
    lcd.printf("smartBIG");       
    while(1)                                                            //Schleife zur Programmwahlabfrage 
        {
        wait(wt);                                                       
        buttonState = read_KEY();                                       //Einlesen des betätigten Buttons
        if (buttonState == LEFT_KEY)                                    //Linker Button
        {
            BlinkerL();
        }
        if (buttonState == RIGHT_KEY)                                   //Rechter Button
        {
            BlinkerR();
        }
        if (buttonState == UP_KEY)                                      //Oben Button
        {
            BlinkerW();
        }
    }
}

// Programm für die Ansteuerung der linken Blinker
void BlinkerL()
{
    buttonState = NO_KEY;                                               //Zurücksetzen des Button-Status aus Programmauswahl
    lcd.cls();
    lcd.locate(1,1);
    lcd.printf("Blinker  Links");
    wait(z);
    lcd.locate(0,0);
    lcd.printf("<--");
    Blinker_L_Led = 1;
    wait(wt);
    buttonState = read_KEY();
    
        if (buttonState == LEFT_KEY)                                    //Einstieg Dauerblinker links
        {   while(1)
            {
                Blinker_L_Led = 0;
                buttonState = NO_KEY;
                lcd.cls();
                lcd.locate(2,1);
                lcd.printf("Dauerblinker");
                wait(z);
                lcd.locate(0,0);
                lcd.printf("<--");
                Blinker_L_Led = 1;
                wait(wt);
                buttonState = read_KEY();
                
                if (buttonState == DOWN_KEY)                            //Abbruchbedingung Dauerblinker links
                {
                Programmwahl();                                         //Zurück zur Programmwahl
                }
                if (buttonState == UP_KEY)                              //Einstieg Warnblinker
                { BlinkerW();}
                if (buttonState == RIGHT_KEY)                           //Einstieg Blinker Rechts
                { 
                Blinker_L_Led = 0;
                BlinkerR();}
            }   
        }
        else                                                            //Einstieg Komfortblinker links
            {
            char x = 3;                                                 //x Zählvariable
            for (x=3; x>=1; x--)
            {
                Blinker_L_Led = 0;
                lcd.cls();
                lcd.locate(1,1);
                lcd.printf("Komfortblinker");
                wait(z);
                lcd.locate(15,0);
                lcd.printf("%d",x);                                     //Ausgabe der Var. x auf dem LCD
                lcd.locate(0,0);
                lcd.printf("<--");
                Blinker_L_Led = 1;
                wait(z);
            }
            }
            Programmwahl();                                        
        }


// Programm für die Ansteuerung der rechten Blinker
void BlinkerR()
{
    buttonState = NO_KEY;
    lcd.cls();
    lcd.locate(1,1);
    lcd.printf("Blinker  Rechts");
    wait(z);
    lcd.locate(13,0);
    lcd.printf("-->");
    Blinker_R_Led = 1;
    wait(wt);
    buttonState = read_KEY();
    
        if (buttonState == RIGHT_KEY)                                   //Einstieg Dauerblinker rechts
        {   while(1)
            {
                Blinker_R_Led = 0;
                buttonState = NO_KEY;
                lcd.cls();
                lcd.locate(2,1);
                lcd.printf("Dauerblinker");
                wait(z);
                lcd.locate(13,0);
                lcd.printf("-->");
                Blinker_R_Led = 1;
                wait(wt);
                buttonState = read_KEY();
                
                if (buttonState == DOWN_KEY)                            //Abbruchbedingung Dauerblinker rechts
                {
                Programmwahl();
                }
                if (buttonState == UP_KEY)                              //Einstieg Warnblinker
                { BlinkerW();}
                if (buttonState == LEFT_KEY)                           //Einstieg Blinker Links
                { 
                Blinker_R_Led = 0;
                BlinkerL();}
            }   
        }
        else                                                            //Einstieg Komfortblinker rechts
            {
            char x = 3;
            for (x=3; x>=1; x--)
            {
                Blinker_R_Led = 0;
                lcd.cls();
                lcd.locate(1,1);
                lcd.printf("Komfortblinker");
                wait(z);
                lcd.locate(0,0);
                lcd.printf("%d",x);
                lcd.locate(13,0);
                lcd.printf("-->");
                Blinker_R_Led = 1;
                wait(z);
            }
            }
            Programmwahl();                                             //Zurück zur Programmwahl
            }

// Programm für die Ansteuerung der Warnblinkroutine
void BlinkerW()
{
     while(1)
     {
             buttonState = NO_KEY;
             lcd.cls();
             lcd.locate(2,1);
             lcd.printf("Warnblinker!");
             Blinker_L_Led = 0;
             Blinker_R_Led = 0;
             wait(z);
             lcd.locate(13,0);
             lcd.printf("-->");
             lcd.locate(0,0);
             lcd.printf("<--");
             Blinker_L_Led = 1;
             Blinker_R_Led = 1;
             
             wait(wt);
             buttonState = read_KEY();
        if (buttonState==DOWN_KEY || buttonState==UP_KEY)               //Doppelte Abschaltbedingung
        {
        Programmwahl();
        }
     }
}

//Routine zum Auslesem der betätigten Taste
int read_KEY()                                                     
{   
    int adc_key_in = 0;
    adc_key_in = KEYS.read_u16 ();                                      //Einlesen der aktuell anliegenden Spannung 
                                                                                                                                                
    if (adc_key_in > 65000)    {return NO_KEY;}                         //Zuordnung der ermittelten Spannungswerte in Intervallen (aufgrund Schwankungen) 
    if (adc_key_in < 300)      {return RIGHT_KEY;}
    if (adc_key_in < 15000)    {return UP_KEY;}
    if (adc_key_in < 35000)    {return DOWN_KEY;}
    if (adc_key_in < 53000)    {return LEFT_KEY;}
      
    return NO_KEY;                                                      //Wenn kein Wert eingelesen werden kann
}

//Ende