/* Simpler prog based on the serial passthrough code to enable a command line driven test of esp8266
* wifi modules.
*/
#include "mbed.h"

Serial pc(USBTX, USBRX); // serial terminal for the pc connection
Serial dev(PTE0,PTE1);  // for KL25Z... asuming one can't use the PTA1 version which is the stdio
DigitalOut led1(LED1); // twp leds
DigitalOut led2(LED2); // to allow visual check of bidirectional comms
DigitalOut rst(PTD7); // single digital pin to drive the esp8266 reset line

// subroutine to run anytime a serial interrupt arrives from the device
// this basically passes everything thatthe device produces on to the pc terminal screen

void dev_recv()
{
    while(dev.readable()) {
        pc.putc(dev.getc());
        wait_us(1);
    }
}
// subroutine to service the serial interrupt on the pc connection
// this is a bit more complex - it takes what the use sends on the pc and copies it on to the device
// the esp should echo these straight back to the the pc if all is well
// this also detects the end of command character which is ascii 13 (0x0d) adn adds a linefeed after it =asscii 10 (0x0a)
void pc_recv()
{
    char c;
    while(pc.readable()) {
        c = pc.getc();
        dev.putc(c);
        //  pc.putc(c); // echo back
        if(c==13) {
            dev.putc(10); // send the linefeed to complement the carriage return generated by return key on the pc
            pc.putc(10);
        }
    }
}

int main()
{
    pc.baud(115200);
    dev.baud(115200);
    rst = 0;
    wait(1);
    rst = 1; // send the esp8266 reset
    wait(1);
    
    led1 = 0, led2 = 1;         //Red LED indicates startup in progress

    pc.attach(&pc_recv, Serial::RxIrq); // attach the two interrupt services
    dev.attach(&dev_recv, Serial::RxIrq);
    dev.printf("AT+RST\r\n");
    wait(10);
    dev.printf("AT+CWJAP=\"BTHub3-WXWX\",\"fdd6f7c682\"\r\n");
    wait(10);
    dev.printf("AT+CIPMUX=1\r\n");
    wait(2);
    dev.printf("AT+CIPSERVER=1,333\r\n");
    wait(2);

    led1 = 1, led2 = 0;     //Green LED indicates startup complete

    while(1) {          //Main code goes here

    }
}