/*Arthur Spencer
Code for KL25Z mbed using MaxSonar-EZ1 range finder and ESP8266 wifi device
*/
#include "mbed.h"

AnalogIn ain(A0);           //Proximity analogue signal
PwmOut buzz(D6);            //Alarm
DigitalOut timer(D7);       //LED proximity indicator
InterruptIn push(PTA5);     //Reste button
int stop;
//int data;

Serial pc(USBTX, USBRX);    //erial terminal for the pc connection
Serial dev(PTE0,PTE1);      //tx & rx for the wifi device
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut rst(PTD7);       //esp8266 reset line


// subroutine to run anytime a serial interrupt arrives from the device
// passes everything thatthe device produces on to the pc terminal screen
void dev_recv()
{
    while(dev.readable()) {
        pc.putc(dev.getc());
        wait_us(1);
    }
}

// subroutine to service the serial interrupt on the pc connection
// this takes what the usb sends on the pc and copies it on to the device
// this also detects the end of command character which is ascii 13 (0x0d) adn adds a linefeed after it = asscii 10 (0x0a)
void pc_recv()
{
    char c;
    while(pc.readable()) {
        c = pc.getc();
        dev.putc(c);
        if(c==13) {
            dev.putc(10); // send the linefeed to complement the carriage return generated by return key on the pc
            pc.putc(10);
        }
    }
}

//Interrupt sequence to receive the 'safe' flag ('x') from the wifi link and stop the alarm
void safe()      
{
    char i = dev.getc();
    if(i == 'x') {
        buzz = 0, timer = 0;
        stop = 1;
        //pc.printf("Alarm off\n\r");
        led2 = 0, led1 = 1, led3 = 1;
        //dev.printf("AT+CIPSEND=2,13\r\n");
        //wait(0.05);
        //dev.printf("Alarm Off\n\r \n\r");
        //wait(0.05);
        /*       if (data == 0) {
                   dev.printf("AT+CIPSEND=3,1\r\n");
                   wait(2);
                   dev.printf("Q\r\n");
                   wait(2);
                   data = 1;
               }*/
    } else {
        pc.putc(i);
        /*   if (i == 'w') {                //Alternative sequence if action is to be taken when an intruder attempts to enter
               stop = 0;
               //pc.printf("INTRUDER\n\r");
               dev.printf("AT+CIPSEND=2,12\r\n");
               wait(0.05);
               dev.printf("INTRUDER\n\r \n\r");
               wait(0.05);
               //data = 1;
           } else {
               pc.putc(i);
           }*/
    }
}


//Interrupt sequence to reset the alarm when the push button is pressed
void activate()
{
    stop = 0;
    //dev.printf("AT+CIPSEND=2,13\r\n");
    //wait(0.05);
    //dev.printf("Alarm Set\n\r \n\r");
    //wait(0.05);
    //pc.printf("Alarm Set\n\r");
    /*    if (data == 1) {
            dev.printf("AT+CIPSEND=3,1\r\n");
            wait(2);
            dev.printf("Q\r\n");
            wait(2);
            data = 0;
        }*/
    led1 = 1, led2 = 1, led3 = 0;
    wait(1);
}

//Main sequence
int main()
{
    float  volts, distance, p, q;
    buzz.period_ms(2);
    timer = 0;
    buzz = 0;
    stop = 0;
    led3 = 1;
    led2 = 1;
    led1 = 0;
    //data = 0;

    pc.baud(115200);
    dev.baud(115200);
    rst = 0;
    wait(1);
    rst = 1; // send the esp8266 reset
    wait(1);

    pc.attach(&pc_recv, Serial::RxIrq); // attach the two wifi interrupt services
    dev.attach(&dev_recv, Serial::RxIrq);
    
    //wifi setup
    dev.printf("AT+RST\r\n");
    wait(10);
    dev.printf("AT+CWJAP=\"BTHub3-WXWX\",\"fdd6f7c682\"\r\n");
    wait(10);
    dev.printf("AT+CIPMUX=1\r\n");
    wait(2);
    dev.printf("AT+CIPSTART=2,\"TCP\",\"192.168.1.95\",333\r\n");
    wait(2);

    led3 = 0, led2 = 1, led1 = 1;

    dev.attach(&safe);      // attach the flag interrupt sequences
    push.rise(&activate);

    while(1) {
        if (stop == 0) {
            volts = ain.read();
            distance = volts*1000;        //distance /cm
            wait(0.5);
            if (distance > 50) {
                timer = 0;
                buzz = 0;
                wait(0.2);
            } else {
                for( p = 0.0f; p < 0.4; p += 0.1) {       //Initial buzz to indicate proximity sensor has detected someone
                    if(p<0.2) {
                        buzz = 0.5;
                        wait(0.1);
                    } else {
                        buzz = 0;
                        wait(0.1);
                    }
                }
                for( p = 0; p < 10; p++) {              //5s LED timer
                    timer = !timer;
                    wait(0.5);
                }
                if (stop ==0) {
                    //dev.printf("AT+CIPSEND=2,9\r\n");
                    //wait(0.05);
                    //dev.printf("Alarm\n\r \n\r");
                    //wait(0.05);
                }
                for( q = 0; q < 1000; q += 1) {       //Alarm
                    if (stop == 0) {
                        led1 = 0;
                        led2 = 1, led3 = 1;
                        for( p = 0.0f; p < 0.5; p += 0.1) {
                            led1 = !led1;
                            if(p<0.25) {
                                buzz = 0.5;
                                wait(0.05);
                            } else {
                                buzz = 0;
                                wait(0.05);
                            }
                        }
                    } else {
                        buzz = 0, timer = 0;
                        led1 = 1, led3 = 1;
                        led2 = 0;
                    }
                }
            }
        } else {
            buzz = 0;
            timer = 0;
        }
    }
}