
//%%%%%% SERVER HUB %%%%%%%



//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%  Initialisations  %%%%%%%%
#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "ID12RFID.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"


Serial pc (USBTX,USBRX);
ID12RFID rfid(PTE23);
DigitalOut rled(LED1);
DigitalOut gled(LED2);
DigitalOut bled(LED3);

int touching = 0;




// the display has a backlight switch on board
DigitalOut LCD_LED(PTA13);   // LED Display
DigitalOut pwr(PTD7); // Power

// the TFT is connected to SPI pin 5-7
//SPI_TFT_ILI9341 TFT(p5, p6, p7, p8, p9, p10,"TFT"); // mosi, miso, sclk, cs, reset, dc for lpc1768
SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1, PTD5, PTD0, PTA13,"TFT"); // mosi, miso, sclk, cs, reset, dc for frdmkl25z
//NB better combination to use a coherent 2x4 block for lcd
//   SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1, PTA16, PTA17, PTC16,"TFT"); // mosi, miso, sclk, cs, reset, dc for frdmkl25z

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%  Subroutine to read the x location of the touch point  %%%%%%%%%%



// need to set x+ to 3V and ground x- then read analogue voltage on ym
//nb need to add a check for actual touch as opposed to random crap

int readX()
{
    int delta=0,xv1=0,xv2=0,k=0;

    AnalogIn yp(PTB3);
    AnalogIn ym(PTB2);
    DigitalOut xp(PTB0);
    DigitalOut xm(PTB1);

    xp=1; // set positive sdie of x high
    xm=0;
    // dont need to do anyhting to set low side as it should be fine.
    // but do need to disconnect yp
    //yp.PinMode(PullNone)
    for(k=0; k<10; k++) { // make 10 readings to average
        xv1+=(int)ym.read_u16();  // get value
        xv2+=(int)yp.read_u16(); // get other value
    }
    delta=abs(xv2-xv1)/10;
    if(delta<300) touching=1;
    else touching=0;
// pc.printf("delta=%d \t %d\n\r",delta,touching);
    xp=0;
    xm=0;
    return(xv2/10); //maybe better to return the average of both....
}
// subroutine to read y values - has different pin functions ..
int readY()
{
    DigitalOut yp(PTB3);
    DigitalOut ym(PTB2);
    AnalogIn xp(PTB0);
    AnalogIn xm(PTB1);

    yp=1; // set positive sdie of x high
    ym=0;
    // dont need to do anyhting to set low side as it should be fine.
    // but do need to disconnect yp
    //yp.PinMode(PullNone)
    int yval=(int)xm.read_u16();  // get value

    yp=0;
    ym=0;
    return(yval);
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%  Home Display  %%%%%%%

void start()
{

    pwr=1;
    wait(0.2);

    LCD_LED = 1;                // backlight on
    rled = 1;
    bled = 1;
    gled = 1;

    TFT.claim(stdout);          // send stdout to the TFT display
    TFT.set_orientation(1);
    TFT.background(Black);      // set background to black
    TFT.foreground(Cyan);      // set chars to white
    TFT.locate(80,110);
    TFT.set_font((unsigned char*) Neu42x35);
    TFT.cls();                  // clear the screen
    TFT.printf("SmOuse");

}

void welcome()
{
    //Greeting
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.set_orientation(1);
    TFT.locate(50,100);
    TFT.printf("W");
    wait(0.05);
    TFT.printf("e");
    wait(0.05);
    TFT.printf("l");
    wait(0.05);
    TFT.printf("c");
    wait(0.05);
    TFT.printf("o");
    wait(0.05);
    TFT.printf("m");
    wait(0.05);
    TFT.printf("e");
    wait(0.05);
    TFT.printf(",");
    wait(0.05);
    TFT.printf(" ");
    wait(0.05);
}


void home()
{
    TFT.cls();
    //show corners
    TFT.circle(10,10,10,0xffff);
    wait(0.1);
    TFT.circle(308,10,10,0xffff);
    wait(0.1);
    TFT.circle(10,229,10,0xffff);
    wait(0.1);
    TFT.circle(308,229,10,0xffff);
    wait(0.1);
    //add menu buttons
    TFT.rect(25,200,155,140,0xffff); //lighting
    TFT.rect(165,200,295,140,0xffff); //AC
    TFT.rect(25,25,93,0,Red); //auto controls

    //text for buttons
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(65,165);
    TFT.printf("Lighting");
    TFT.locate(195,165);
    TFT.printf("AC Control");
    TFT.locate(40,10);
    TFT.printf("AUTO");
}

void lights()
{

    TFT.cls();
    TFT.locate(55,15);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.printf("Lighting System");
    //show corners
    TFT.circle(10,10,10,0xffff);
    wait(0.1);
    TFT.circle(308,10,10,0xffff);
    wait(0.1);
    TFT.circle(10,229,10,0xffff);
    wait(0.1);
    TFT.circle(308,229,10,0xffff);
    wait(0.1);
    //add menu buttons
    TFT.rect(25,200,155,140,0xffff);
    TFT.rect(165,110,295,80,0xffff);
    TFT.rect(165,155,295,125,0xffff);
    TFT.rect(165,200,295,170,0xffff);
    //text for buttons
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(50,165);
    TFT.printf("LIGHTS OFF");
    TFT.locate(230,92);
    TFT.printf("3");
    TFT.locate(230,137);
    TFT.printf("2");
    TFT.locate(230,182);
    TFT.printf("1");
    TFT.locate(6,6);
    TFT.printf("X");
}

void temps()
{

    TFT.cls();
    TFT.locate(90,15);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.printf("AC System");
    //show corners
    TFT.circle(10,10,10,0xffff);
    wait(0.1);
    TFT.circle(308,10,10,0xffff);
    wait(0.1);
    TFT.circle(10,229,10,0xffff);
    wait(0.1);
    TFT.circle(308,229,10,0xffff);
    wait(0.1);
    //add menu buttons
    TFT.rect(25,200,155,140,0xffff);
    TFT.rect(165,200,295,140,0xffff);
    //text for buttons
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(60,165);
    TFT.printf("FAN OFF");
    TFT.locate(200,165);
    TFT.printf("FAN ON");
    TFT.locate(6,6);
    TFT.printf("X");
}

void autos()
{

    TFT.cls();
    TFT.locate(30,15);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.printf("Automatic Control");
    //show corners
    TFT.circle(10,10,10,0xffff);
    wait(0.1);
    TFT.circle(308,10,10,0xffff);
    wait(0.1);
    TFT.circle(10,229,10,0xffff);
    wait(0.1);
    TFT.circle(308,229,10,0xffff);
    wait(0.1);
    //add menu buttons
    TFT.rect(25,200,155,140,0xffff);
    TFT.rect(165,200,295,140,0xffff);
    //text for buttons
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(75,165);
    TFT.printf("OFF");
    TFT.locate(215,165);
    TFT.printf("ON");
    TFT.locate(6,6);
    TFT.printf("X");
}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%  IDs  %%%%%%

void ben()
{

    rled = 0;
    bled = 1;
    gled = 1;

    TFT.printf("B");
    wait(0.05);
    TFT.printf("e");
    wait(0.05);
    TFT.printf("n");
}

void joe()
{
    rled = 1;
    bled = 0;
    gled = 1;

    TFT.printf("J");
    wait(0.05);
    TFT.printf("o");
    wait(0.05);
    TFT.printf("e");

}

void arthur()
{
    rled = 1;
    bled = 0;
    gled = 1;

    TFT.printf("A");
    wait(0.05);
    TFT.printf("r");
    wait(0.05);
    TFT.printf("t");
    wait(0.05);
    TFT.printf("h");
    wait(0.05);
    TFT.printf("u");
    wait(0.05);
    TFT.printf("r");

}

void intruder()
{
    rled = 0;
    bled = 0;
    gled = 0;
    TFT.cls();                // clear the screen
    TFT.set_font((unsigned char*) Neu42x35);
    TFT.locate(45,105);
    TFT.foreground(Red);
    TFT.printf("INTRUDER!");
    wait(0.4);
    TFT.cls();
    wait(0.2);
    TFT.locate(45,105);
    TFT.printf("INTRUDER!");
    wait(0.4);
    TFT.cls();
    wait(0.2);
    TFT.locate(45,105);
    TFT.printf("INTRUDER!");
    wait(0.4);
    TFT.cls();
    wait(0.2);
    TFT.locate(45,105);
    TFT.printf("INTRUDER!");
    wait(0.4);
    TFT.cls();
    wait(0.2);
    TFT.locate(45,105);
    TFT.foreground(White);
    TFT.cls();
    rled = 1;
    bled = 1;
    gled = 1;
}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




int main()
{
    int display = 0;
    int reading = 0;
    int id = 0;

    pc.baud(115200);

    int xpos=0,ypos=0,xp=0,yp=0;

    while (1) {

        pc.printf("%d",id);

        switch (display) {

            case 0 : //start screen

                start();

                while (display == 0) {

                    reading = rfid.readable();
                    if (reading) {
                        display = 1;    //FOR TESTING LIGHTING, SHOULD BE 1
                        id = rfid.read();
                    }

                }
                break;

            case 1 : //welcome screen

                home();

                //Personalised
                switch (id) {

                    case 22311780 : //Ben
                        welcome();
                        ben();
                        break;

                    case 22320978 : //Joe
                        welcome();
                        joe();
                        break;

                    case 22352757 : //Arthur
                        welcome();
                        arthur();
                        break;

                    default : //intruder case
                        intruder();
                        display = 0;
                        break;
                }
                if (display == 0) { //intruder restarts system
                    break;
                }
                while (display == 1) {
                    //%%%%% INCOMING DATA %%%%%%
                    TFT.set_orientation(1);
                    TFT.foreground(White);
                    TFT.locate(145,0);
                    TFT.set_font((unsigned char*) Arial12x12);
                    TFT.printf("Temperature: 25.0 C");
                    TFT.locate(145,15);
                    TFT.printf("Fan: On");
                    TFT.locate(145, 30);
                    TFT.printf("Lights: Low");
                    TFT.foreground(Cyan);

                    //%%%%% TOUCH %%%%%%
                    TFT.set_orientation(0);
                    xpos= readX();
                    ypos= readY();

                    xp=(240*(xpos-5800))/51200;
                    yp=320-(320*(ypos-3000))/58300;

                    if (yp<120 && xp<120 && touching==1) { //button for lighting

                        display = 2;            //jump to lights
                        TFT.set_orientation(1);
                    }

                    if (yp>230 && xp<120 && touching==1) { //button for ac system

                        display = 3;            //jump to ac
                        TFT.set_orientation(1);
                    }

                    if (yp<100 && xp>120 && touching==1) { //button for auto control

                        display = 4;            //jump to automatic control
                        TFT.set_orientation(1);
                    }

                    //%%%%%% RFID Override %%%%%%%%
                    reading = rfid.readable();
                    if (reading) {
                        id = rfid.read();
                        TFT.set_orientation(1);
                        break;
                    }
                }
                break;

            case 2 : //lighting screen


                lights();

                while (display == 2) {

                    //%%%%% TOUCH %%%%%%
                    TFT.set_orientation(0);
                    xpos= readX();
                    ypos= readY();

                    xp=(240*(xpos-5800))/51200;
                    yp=320-(320*(ypos-3000))/58300;

                    if (yp<120 && xp<120 && touching==1) { //button for LIGHTS OFF

                        //LIGHTS OFF ACTION
                    }

                    if (yp>230 && xp<60 && touching==1) { //button for LIGHTS 1

                        //LIGHTS 1 ACTION
                    }

                    if (yp>230 && 70<xp<110 && touching==1) { //button for LIGHTS 2

                        //LIGHTS 2 ACTION
                    }

                    if (yp>230 && xp>115 && touching==1) { //button for LIGHTS 3

                        //LIGHTS 3 ACTION
                    }

                    if (yp<30 && xp>210 && touching==1) { //RETURN TO MAIN SCREEN

                        display = 1;
                        TFT.set_orientation(1);
                    }


                    //%%%%%% RFID Override %%%%%%%%
                    reading = rfid.readable();
                    if (reading) {
                        id = rfid.read();
                        TFT.set_orientation(1);
                        display = 1;
                    }
                }
                break;

            case 3 : //temperature screen


                temps();

                while (display == 3) {

                    //%%%%% TOUCH %%%%%%
                    TFT.set_orientation(0);
                    xpos= readX();
                    ypos= readY();

                    xp=(240*(xpos-5800))/51200;
                    yp=320-(320*(ypos-3000))/58300;

                    if (yp<120 && xp<120 && touching==1) { //button for FAN OFF

                        //FAN OFF ACTION
                    }

                    if (yp>230 && xp<120 && touching==1) { //button for FAN ON

                        //FAN ON ACTION
                    }

                    if (yp<30 && xp>210 && touching==1) { //RETURN TO MAIN SCREEN

                        display = 1;
                        TFT.set_orientation(1);
                    }


                    //%%%%%% RFID Override %%%%%%%%
                    reading = rfid.readable();
                    if (reading) {
                        id = rfid.read();
                        TFT.set_orientation(1);
                        display = 1;
                    }
                }
                break;

            case 4 : //auto controls


                autos();

                while (display == 4) {

                    //%%%%% TOUCH %%%%%%
                    TFT.set_orientation(0);
                    xpos= readX();
                    ypos= readY();

                    xp=(240*(xpos-5800))/51200;
                    yp=320-(320*(ypos-3000))/58300;

                    if (yp<120 && xp<120 && touching==1) { //button for AUTO OFF

                        //AUTO OFF ACTION
                    }

                    if (yp>230 && xp<120 && touching==1) { //button for AUTO ON

                        //AUTO ON ACTION
                    }

                    if (yp<30 && xp>210 && touching==1) { //RETURN TO MAIN SCREEN

                        display = 1;
                        TFT.set_orientation(1);
                    }


                    //%%%%%% RFID Override %%%%%%%%
                    reading = rfid.readable();
                    if (reading) {
                        id = rfid.read();
                        TFT.set_orientation(1);
                        display = 1;
                    }
                }
                break;
        }
    }
}