#include "mbed.h"

AnalogIn noise(p19);
DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);
DigitalIn bryter(p20);

Timer t1;
BusOut bargraph(p21, p22, p23, p24, p25, p26);
int noiseValue();
int tid;
Timer t2;
int noiseValue(int low, int high);

int main()
{
    srand(noiseValue(1, 1000));
    while(1) {
        int tid = 0;
        Led1 = 1;
        wait(1);
        Led2 = 1;
        wait(1);
        Led3 = 1;
        wait(rand()%10 + 1);
        Led4 = 1;
        t1.start();

        while(bryter == 0) {
            wait_ms(1);
        }
        
        t1.stop();
        tid = t1.read_ms();
        bargraph = tid / 10;
    }
}



int noiseValue(int low, int high)
{
    uint16_t reading, rnd;
    reading = noise.read_u16() & 0xFFF; // keep 12 lsb
    reading *= 13;
    rnd = reading % (high - low + 1);   // find remainder
    rnd += low;
    return rnd;
}

