#include "mbed.h"

#define RED 4
#define YELLOW 2
#define GREEN 1
#define ON 1
#define OFF 0

#define _10SEK 100
#define _5SEK 50
#define _4SEK 40
#define _2SEK 20
#define _1SEK 10

BusOut ew_lights(p26, p27, p28); //Lyskryss retning OV
BusOut ns_lights(p21, p22, p23); //Lyskryss retnng NS 
DigitalIn PED(p12);   //Trykkbryter for ganglys
DigitalOut FK(LED1);  //Ganglys klart
DigitalOut FV(LED4);  //Ganglys vent
Ticker tc; // 10 Hz Klokke

int time_tick = 0;
volatile int knapp = 0;

enum {OV0, OV1, OV2, OV3, NS0, NS1, NS2, NS3, PED1, PED2, ILLEGAL} state;

void day_night_control(void);
void tick_control(void);
void fsm(void);

volatile int sysclock = 0;

int main(void) {
    tc.attach(&tick_control, 0.05);
    state = OV0;
    time_tick = 0;
    
    while(1) {
        fsm();
        while (sysclock == 1);
        while (sysclock == 0);
        time_tick++;
    }
}

void tick_control()
{
    sysclock = !sysclock;
}

void fsm(void)
{
    static int knapp = 0;
    switch(state) {
        case OV0:
        ns_lights = RED;
        ew_lights = GREEN;
        FK = OFF;
        FV = ON;
        if (PED == ON) {
            knapp = 1;
        }
        if (time_tick >= _10SEK) {
            time_tick = 0;
            state = OV1;
        }
        break;
        case OV1:
        ns_lights = RED;
        ew_lights = YELLOW;
        FK = OFF;
        FV = ON;
        if (PED == ON) {
            knapp = 1;
        }
        if (time_tick >= _2SEK) {
            time_tick = 0;
            state = OV2;
        }
        break;
        case OV2:
        ns_lights = RED;
        ew_lights = RED;
        FK = OFF;
        FV = ON;
        if (PED == ON || knapp == 1) {
            time_tick = 0;
            state = PED1;
            knapp = 0;
        }
        if (time_tick >= _1SEK) {
            time_tick = 0;
            state = OV3;
        }
        break;
        case OV3:
        ns_lights = RED+YELLOW;
        ew_lights = RED;
        FK = OFF;
        FV = ON;
        if (PED == ON) {
            knapp = 1;
        }
        if(time_tick >= _1SEK) {
            time_tick = 0;
            state = NS0;
        }
        break;
        case NS0:
        ns_lights = GREEN;
        ew_lights = RED;
        FK = OFF;
        FV = ON;
        if (PED == ON) {
            knapp = 1;
        }
        if(time_tick >= _5SEK) {
            time_tick = 0;
            state = NS1;
        }
        break;
        case NS1:
        ns_lights = YELLOW;
        ew_lights = RED;
        FK = OFF;
        FV = ON;
        if (PED == ON) {
            knapp = 1;
        }
        if(time_tick >= _2SEK) {
            time_tick = 0;
            state = NS2;
        }
        break;
        case NS2:
        ns_lights = RED;
        ew_lights = RED;
        FK = OFF;
        FV = ON;
        if (PED == ON || knapp == 1) {
            time_tick = 0;
            state = PED2;
            knapp = 0;
        }
        if(time_tick >= _1SEK) {
            time_tick = 0;
            state = NS3;
        }
        break;
        case NS3:
        ns_lights = RED;
        ew_lights = RED+YELLOW;
        FK = OFF;
        FV = ON;
        if (PED == ON) {
            knapp = 1;
        }
        if(time_tick >= _1SEK) {
            time_tick = 0;
            state = OV0;
        }
        break;
        case PED1:
        ns_lights = RED;
        ew_lights = RED;
        FK = ON;
        FV = OFF;
        if(time_tick >= _10SEK) {
            time_tick = 0;
            state = OV3;
        }
        break;
        case PED2:
        ns_lights = RED;
        ew_lights = RED;
        FV = OFF;
        FK = ON;
        if(time_tick >= _10SEK) {
            time_tick = 0;
            state = NS3;
        }
        break;
    }
}
