#include <string>
#include "mbed.h"
#include <time.h>
#include "rtos.h"
#include <Ticker.h>
#include "MODSERIAL/MODSERIAL.h"
#include "NMEA/NMEA.h"
#include "USBHostMSD.h"
#include "WDT/WDT.h"
#include "SPS/SPS.h"
#include "BMAG/BMAG.h"
#include "ErrorHandler/ErrorHandler.h"
#include "BME280/BME280.h"

#define FWSRCVERSION "x"
#define FWIVERSION "1.0.0.7"
#define IDENTIFIERID "00"
#define ENCODING "0"
#define TIMEZONE "ZZZ"
#define SOURCEIDENTIFICATION "0000"
#define GROUP "00"
#define DATALINEVERSION "04"
#define TAG "BMAG"
 
using namespace std;

//GPS communication init
static MODSERIAL gps(p13, p14, 128);

//BMAG communication init
static MODSERIAL bmag(p9, p10, 64);

//Debug serial connection
static Serial dbg(USBTX, USBRX);

//GPS Rx callback prototype
void rxCallback(MODSERIAL_IRQ_INFO *q);

//BMAG Rx callback prototype
void bmagrxCallback(MODSERIAL_IRQ_INFO *q);

//GPS NMEA Parser
static NMEA gpsNMEA;

//BMAG Parser
static BMAG magParser;

//BME280 i2c conn
static I2C BME280_i2c(p28, p27);

//BME 280 instance
static BME280 BME;

//EA_OLED display
Thread thr_writelines;
SPI * spiptr;
DigitalOut * csptr;
string l1;
string l2;
    
void init_config(char c){
    *csptr = 0; //chip select to start data transmission    
    spiptr->write(c);
    *csptr = 1; //chip select to end data transmission
    wait_us(2);       
};

    
void EA_OLED(){
    //clear l1 and l2
    
    l1 = "";
    l2 = "";
    
    spiptr = new SPI(p5, p6, p7);
    csptr = new DigitalOut(p8); 
    
    *csptr = 1; //high at idle 
    
    spiptr->format(10,3); //10bit, high steady state clock
    spiptr->frequency(1000000); //1MHz spi clock 
    
    
    //function set european chararacter set
    init_config(0x39);
    //display off
    init_config(0x08);
    //entry mode set increment cursor by 1 not shifting display
    init_config(0x06);
    //Character mode and internel power on
    init_config(0x17);
    //clear display
    init_config(0x01);
    //return home
    init_config(0x02);
    //display on
    init_config(0x0C);        
    wait_ms(10); //Time to stabilize (wont work without)
    
     
};


void clear_display(){
    //clear display
    *csptr = 0; //chip select to start data transmission    
    spiptr->write(0x01);
    *csptr = 1; //chip select to end data transmission
    Thread::wait(1);       
};

void clear_display_waiting(){
    //clear display
    init_config(0x01);
    wait_ms(1); 
};

void write_lines(){
        
        //cursor return
        *csptr = 0; //chip select to start data transmission    
        spiptr->write(0x02);
        *csptr = 1; //chip select to end data transmission
        Thread::wait(1);
        
        //write l1
        for(int i = 0; i < strlen(l1.c_str()); i++){
            *csptr = 0; //chip select to start data transmission
            spiptr->write(0x200 | l1[i]); //add 0x02 for character transmission
            *csptr = 1; //chip select to end data transmission
            Thread::wait(1);       
        }
               
        //cursor return + cursor pos set
        *csptr = 0; //chip select to start data transmission    
        spiptr->write(0x02);
        *csptr = 1; //chip select to end data transmission
        wait_us(1000);
        Thread::wait(1);
        
        for(int i = 0; i < 64; i++){
            *csptr = 0; //chip select to start data transmission    
            spiptr->write(0x14);
            *csptr = 1; //chip select to end data transmission
            wait_us(2);         
        }   
         
        
        //write l2
        for(int i = 0; i < strlen(l2.c_str()); i++){
            *csptr = 0; //chip select to start data transmission
            spiptr->write(0x200 | l2[i]); //add 0x02 for character transmission
            *csptr = 1; //chip select to end data transmission
            wait_us(1000);
            Thread::wait(1);        
        }
        //dbg.printf("Display_Updated\r\n");           
};

