#pragma once
#include <string>
#include "mbed.h"

#define LINESTART '>'
#define LINESTOP '<' 
#define HEADEREND '|'
#define SPACE ' '

#define P_16 0xA001 

using std::string;


//! An *.SPS format handler class
/*!
    This class is used to create and handle creation of *.sps strings for *.sps files.
*/
class SPS{
public:
    //default constructor
    SPS();    
    
    //Updates current string     
    void UpdateCurrentString(string tag, string identifier_id, string group_id, string date, string time, string ZZZ,string encoding, string source_id, string interpreter_id, string data_line_version, string source_firmware_version, string interpreter_firmware_version, string barcode, string latitude, string longitude, bool gpsFixFlag, string batteryvoltage, string preassure, string temperature, string humidity, string altitude, string mag_time, string mag_nt, string mag_sq, Serial * dbg);
    
    //Updates current header string
    void UpdateHeaderString(string barcode, string identifier_id, string group_id, string ZZZ, string encoding,string source_id, string interpreter_id, string data_line_version, string source_firmware_version, string interpreter_firmware_version);

    //Updates current ERR     
    void UpdateCurrentErrString(string tag, string identifier_id, string group_id, string date, string time, string ZZZ,string encoding, string source_id, string interpreter_id, string data_line_version, string source_firmware_version, string interpreter_firmware_version, string latitude, string longitude, bool gpsFixFlag, string mag_time, string mag_nt, string mag_sq, Serial * dbg);
    
    //Fills the array for calculation of the CRC-16 with values
    void init_crc16_tab();
    
    //The function update_crc_16 calculates a new CRC-16 value based on the 
    //previous value of the CRC and the next byte of the data to be checked.
    unsigned short update_crc_16(unsigned short crc, char c);    
    
    //Gets / returns current sps data string
    string getCurrentString(void);
    
    //Gets / returns current sps err string
    string getCurrentErrString(void);
    
    //get headerstring
    string getHeaderString(void);
    
    //Get error status
    bool getErrStatus(void);    
    
    //set Error status
    void setErrStatus(bool status);
    
    //add data to current string
    void addToCurrentString(string data);
    void addToCurrentString(char data);
    
    //add data to current Errstring
    void addToCurrentErrString(string data);
    void addToCurrentErrString(char data); 
    
    //add data to current Header string
    void addToCurrentHeaderString(string data);
    void addToCurrentHeaderString(char data);
    
    //generate sps filename
    void generateSpsFilename(string formattedDate, string barcode, string time);
    
    //get sps filename
    string getSpsFileName(void);
            
private:  
    string fileNameString;  
    string currentString;
    string lastString;
    string currentErrString;
    string headerString;
    bool errStatus;
    int crc_tab16_init;            
    unsigned short crc_tab16[256];  
                     
};
