#include "ErrorHandler.h"


//! ErrorHandler, default constructor
ErrorHandler::ErrorHandler(){
    errorStr1.assign("        ");
    errorStr2.assign("        ");
    currentState  = NONE;
    setMagTimePrompted = false;
    memset(tmparr,'\0',10);
    magPromptCounter = 0;   
};


//! ErrorHandler, constructor taking a few inputs
/*!
    This constuctor takes a few inputs, to enable more functionality
    
    \param batteryvoltage A string pointer, enabling the class to access the current battery voltage string
    \param fix A bool pointer, pointing to a boolean flag with gps fix status
    \param bmag A BMAG object pointer, enabling the access to mag data directly from this class
    \param gps An NMEA object pointer to a gps in this case 
*/
ErrorHandler::ErrorHandler(string * batteryvoltage, bool * fix, BMAG * bmag, NMEA * gps){
    errorStr1.assign("        ");
    errorStr2.assign("        ");
    currentState  = NONE;
    memset(tmparr,'\0',10);
    fixptr = fix;
    batteryvoltageptr = batteryvoltage;
    bmagptr = bmag;
    gpsPtr = gps;
    setMagTimePrompted = false;
    magPromptCounter = 0;       
};

//! getLine1 is an error string getter method
/*!
    This method returns the first row of input used in a display
    
    \return errorStr1 a string containing the first display row 
    
*/
string ErrorHandler::getLine1(void){
    return errorStr1;
};

//! getLine2 is an error string getter method
/*!
    This method returns the second row of input used in a display
    
    \return errorStr2 a string containing the second display row 
    
*/
string ErrorHandler::getLine2(void){
    return errorStr2;
};


//! setErrorState is a error state setter method.
/*!
    Used to set the current errorstate, and changing the display texts accordingly
    
    \param es The errorstate needed of type ErrorState  
*/
void ErrorHandler::setErrorState(ErrorState es){
   
   this->currentState = es;    
    
    switch(currentState){
        
        case(NONE):
            errorStr1.assign("        ");
            errorStr2.assign("        ");
            break;
            
        case(NO_GPS):
            errorStr1.assign("GPS Data");
            errorStr2.assign("!Missing");
            break;            
        
        case(NO_FIX):
            errorStr1.assign("SetClock");
            errorStr2.assign("!on mag ");
            
            if(magPromptCounter <= 30){
                magPromptCounter += 1;
            }
            if(magPromptCounter > 30){
                setMagTimePrompted = true;      
            }                  
            break;
        
        case(NO_MAG_DATA):
            memset(tmparr,'\0',15);
            sprintf(tmparr, "%s", gpsPtr->getCurrentTime().c_str());
            errorStr1.assign("!MagData");
            
            if(*fixptr){
                errorStr2.assign(tmparr);
            }
            if(!(*fixptr)){
                errorStr2.assign("!NoFix  ");
            }                     
            break;
        
        case(DISPLAY_VBAT_FIX):
            memset(tmparr,'\0',15);
            sprintf(tmparr, "VB: %s", *(batteryvoltageptr));
            errorStr1.assign(tmparr);
            
            if(*fixptr){
                errorStr2.assign("FIX: OK ");    
            }
            
            if(!(*fixptr)){
                errorStr2.assign("FIX:NONE");                
            }
            break;
            
        case(DISPLAY_MAG_MEASUREMENT):
            //memset(tmparr,'\0',15);
            errorStr1.assign("BMAG    ");  
            //errorStr1[2] = bmagptr->getMagSq()[0];
            //errorStr1[3] = bmagptr->getMagSq()[1];
            
            //sprintf(tmparr, "%s",bmagptr->getMagNTStr().c_str());
            errorStr2.assign("Working ");
            break;
            
        case(BATTERY_LOW):
            errorStr1.assign("Battery ");
            errorStr2.assign("!Low    ");
            break;
                
        case(GPS_OVERRIDE_NEEDED):
            errorStr1.assign("!GPS    ");
            errorStr2.assign("Override");
            break;
        
        default:
            break;
    }    
};


//! getMagTimePromtStatus is a prompt status flag getter method
/*!
    Returns the status of the setMagTimePrompted flag, indicating if a "please set the clock on bmag" prompt has been shown on display.
    
    \return setMagTimePrompted A bool indicating if user has been prompted to set time on mag or not.
*/
bool ErrorHandler::getMagTimePromtStatus(void){
    return this->setMagTimePrompted;  
};

//! getErrorState is a method returning the current errorstate
/*!
    Returns the current errorstate
    
    \return currentState The current ErrorState
*/
ErrorState ErrorHandler::getErrorState(void){
  return   this->currentState;
};