#pragma once
#include <string>
#include "mbed.h"
#include "BMAG/BMAG.h"
#include "NMEA/NMEA.h"

using std::string;

enum ErrorState{NONE, NO_GPS, NO_FIX, NO_MAG_DATA, DISPLAY_VBAT_FIX, DISPLAY_MAG_MEASUREMENT, BATTERY_LOW, GPS_OVERRIDE_NEEDED};


//! An Error Handler class
/*!
    This class is used to handle error states, and display texts of the bmag usb logger.
*/
class ErrorHandler{

public:
    //constructor
    ErrorHandler();
    
    //constructor with display ptr
    ErrorHandler(string * batteryvoltage, bool * fix,BMAG * bmag, NMEA * gps);
    
    //get display lines
    string getLine1(void);
    string getLine2(void);
    
    //get mag time prompt status
    bool getMagTimePromtStatus(void);
    
    //sets errorstate and assigns the correct line values for display
    void setErrorState(ErrorState es);
    
    //gets errorstate
    ErrorState getErrorState(void);
      
    bool setMagTimePrompted;
        
private:
    string errorStr1;
    string errorStr2;
    int magPromptCounter;
    char tmparr[15];
    bool * fixptr;
    string * batteryvoltageptr;
    BMAG * bmagptr;
    NMEA * gpsPtr;
    ErrorState currentState; 
};