#pragma once
#include <string>
#include "mbed.h"
#include "MODSERIAL/MODSERIAL.h"

using std::string;


//! A BMAG string handling class
/*!
    This class is used to handle / parse the default data logging string
    sent via rs232 to an external device from a GSM-19T magnetometer unit.
    Methods of this class parse the received rs232 string and convert them into
    individual data strings. (magTime, magnTMeasurement, and magMeasurementQuality)
*/

class BMAG{
    
public:
    
    //! The default constructor. No arguments are needed for this class ever.
    BMAG();

    //string parser
    void parseBMAGString(string str);
    
    //magtime string set method
    void setMagTimeStr(string magT);
    
    //magnt string set method
    void setMagNTStr(string magNT);
    
    //magsq string set method
    void setMagSqStr(string magSq);
    
    //magtime string get method
    string getMagTimeStr(void);
    
    //magnt string get method
    string getMagNTStr(void);
    
    //magsq string get method
    string getMagSq(void);
    
    //mag string returner
    string getColumn(string str, char n);

private:    
    string lastMagTime;
    string lastMagNT;
    string lastMagSq;
};