#pragma once
#include "mbed.h"
#include <string>

using std::string;

//! An NMEA handler class
/*!
    This class is used to handle NMEA strings, from eg. a GPS device.
*/
class NMEA{
public:
    //default constructor
    NMEA();    
    
    //validate received data
    //returns true if valid
    bool ValidateData(string cstStr);
    
    //Store function to move GGA to currentGGAString, 
    //or GPRMC to currentGPRMCString
    void StoreString(string cstStr);
    
    //Parser getting current UTC timestamp from GPRMC
    void ParseCurrentUTCFromGPRMC(void);
    
    //Parser getting current Date from GPRMC
    void ParseCurrentDateFromGPRMC(void);
    
    //Parser getting current Latitude
    void ParseCurrentLatitudeFromGPRMC(void);
    
    //Parser getting current Longitude
    void ParseCurrentLongitudeFromGPRMC(void);
    
    void ParseCurrentAltitudeFromGGA(void);
    
    //Verification of gps fix, if fix is ok, return true, if not return false.
    bool GGAFixVerification(void);
    
    //get data string from NmeaString
    void getXFromNMEAString(int desiredCommaCount, string stringToParse);
    
    //getter method returning current UTC from NMEA class
    string getCurrentTime(void);
        
    
    string currentGGAString;
    string currentGPRMCString;
    string currentUTCFromGPRMC;
    string currentDATEFromGPRMC;
    string currentLatitude;
    string currentLongitude;  
    string currentAltitude;  
    string tmpStr;  
    
    int cnt_GPRMC;
    
    float longitudeDD;
    float latitudeDD;

private:

    string chkSumGps;
    char iterationIndex;
    int GpsCheck;
    int chkSum;

    bool north, east, south, west;
    char tmpArrDeg[7];
    char tmpArrMin[7];
    char tmpLongitude[15]; 
    char tmpLatitude[15];  
};
