#include "BMAG.h"

//! The default constructor. No arguments are needed for this class ever.
/*!
  Initializes private members needed when the object is operational.
*/
BMAG::BMAG(){
    lastMagTime.resize(25);
    lastMagNT.resize(25);
    lastMagSq.resize(25);    
    
};

//! Parser method. Parsing the GSM-19T RS232 strings.
/*!
  Parses the RS232 string received from the GSM-19T and ensures splitting,
  and storage of the different data elements of the string.
  
  \param str The complete rs232 string from GSM-19T.
  
*/
void BMAG::parseBMAGString(string str){
    string tmpmagStr = "";
    
    //get first mag string column
    tmpmagStr.assign(getColumn(str, 0));
    

    setMagTimeStr(tmpmagStr);
    tmpmagStr = ""; 
    
    //get second mag string column
    tmpmagStr.assign(getColumn(str, 1)); 
    setMagNTStr(tmpmagStr.substr(1));
    
    tmpmagStr = ""; 
    
     //get third mag string column
    tmpmagStr.assign(getColumn(str, 2));        
    
    setMagSqStr(tmpmagStr);
    
    
};


//! magTimeString string setting method.
/*!
    sets the lastMagTime string to the received magT argument string value
    
    \param magT Mag time data field as a string
*/
void BMAG::setMagTimeStr(string magT){
    lastMagTime.assign(magT);  
};


//! magMeasurement string setting method.
/*!
    sets the lastMagNt string to the received magNT argument string value
    
    \param magNT Mag nanoTesla data field as a string
*/
void BMAG::setMagNTStr(string magNT){
    lastMagNT.assign(magNT);  
};

//! magMeasurementQuality string setting method.
/*!
    sets the lastMagSq string to the received magSq argument string value
    
    \param magSq Mag measurement quality data field as a string
*/
void BMAG::setMagSqStr(string magSq){
    lastMagSq.assign(magSq);  
};


//! Mag time data field string getter method.
/*!
    Returns the lastMagTime string
    
    \return A string with the mag time data field
*/ 
string BMAG::getMagTimeStr(void){
    return lastMagTime;     
};

//! Mag nanoTesla measurement data field string getter method.
/*!
    Returns Mag nanoTesla measurement
    
    \return A string with the Mag nanoTesla measurement
*/ 
string BMAG::getMagNTStr(void){
    return lastMagNT;
};


//! Mag measurement quality data field string getter method.
/*!
    Returns Mag measurement quality
    
    \return Mag measurement quality data field string
*/ 
string BMAG::getMagSq(void){
    return lastMagSq;  
};

//! mag string column search method.
/*!
    Returns the desired data column of the original GSM-19T measurement string.
    
    \param str Iriginal GSM-19T measurement string
    \param n Desired data column, 0 indexed. Eg. First column(Time): n = 0. Second column(mag measurement in nT): n = 1. Third column(Measurement Quality): n = 2.
    \return desired data column as string.
*/
string BMAG::getColumn(string str, char n){
    
    char count = 0;
    string tmpStr = "";
    string result = "";
    
    tmpStr.resize(40);
    char indexcnt = 0;
    
    
    for(int i = 0; i < str.size(); i++){
        if(count == n && (str[i] != '\r') || count == n && (str[i] != '\n')){
            tmpStr[indexcnt] = str[i];
            indexcnt += 1;    
        }
        
        if(str[i] == '\r' || str[i] == ' '){
            count += 1;    
        }
        
        if(count > n){
            break;    
        }        
    }
    
    for(int i = 0; i < tmpStr.size(); i++){
        if(tmpStr[i] != ' ' && tmpStr[i] != '\n' && tmpStr[i] != '\r'){
             result += tmpStr[i]; 
        }    
    }
    
    return result;
        
};



